/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.validate;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.org.apache.calcite.sql.SqlSelect;
import com.hazelcast.org.apache.calcite.sql.validate.DelegatingScope;
import com.hazelcast.org.apache.calcite.sql.validate.SqlMoniker;
import com.hazelcast.org.apache.calcite.sql.validate.SqlNameMatcher;
import com.hazelcast.org.apache.calcite.sql.validate.SqlNonNullableAccessors;
import com.hazelcast.org.apache.calcite.sql.validate.SqlQualified;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorNamespace;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorUtil;
import com.hazelcast.org.apache.calcite.util.Static;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;

public class OrderByScope
extends DelegatingScope {
    private final SqlNodeList orderList;
    private final SqlSelect select;

    OrderByScope(SqlValidatorScope parent, SqlNodeList orderList, SqlSelect select) {
        super(parent);
        this.orderList = orderList;
        this.select = select;
    }

    @Override
    public SqlNode getNode() {
        return this.orderList;
    }

    @Override
    public void findAllColumnNames(List<SqlMoniker> result) {
        SqlValidatorNamespace ns = this.validator.getNamespaceOrThrow(this.select);
        this.addColumnNames(ns, result);
    }

    @Override
    public SqlQualified fullyQualify(SqlIdentifier identifier) {
        if (identifier.isSimple() && this.validator.config().sqlConformance().isSortByAlias()) {
            String name = (String)identifier.names.get(0);
            SqlValidatorNamespace selectNs = this.validator.getNamespaceOrThrow(this.select);
            RelDataType rowType = selectNs.getRowType();
            SqlNameMatcher nameMatcher = this.validator.catalogReader.nameMatcher();
            RelDataTypeField field = nameMatcher.field(rowType, name);
            int aliasCount = this.aliasCount(nameMatcher, name);
            if (aliasCount > 1) {
                throw this.validator.newValidationError(identifier, Static.RESOURCE.columnAmbiguous(name));
            }
            if (field != null && !field.isDynamicStar() && aliasCount == 1) {
                return SqlQualified.create(this, 1, selectNs, identifier);
            }
        }
        return super.fullyQualify(identifier);
    }

    private int aliasCount(SqlNameMatcher nameMatcher, String name) {
        int n = 0;
        for (SqlNode s2 : SqlNonNullableAccessors.getSelectList(this.select)) {
            String alias = SqlValidatorUtil.getAlias(s2, -1);
            if (alias == null || !nameMatcher.matches(alias, name)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public @Nullable RelDataType resolveColumn(String name, SqlNode ctx) {
        SqlValidatorNamespace selectNs = this.validator.getNamespaceOrThrow(this.select);
        RelDataType rowType = selectNs.getRowType();
        SqlNameMatcher nameMatcher = this.validator.catalogReader.nameMatcher();
        RelDataTypeField field = nameMatcher.field(rowType, name);
        if (field != null) {
            return field.getType();
        }
        SqlValidatorScope selectScope = this.validator.getSelectScope(this.select);
        return selectScope.resolveColumn(name, ctx);
    }

    @Override
    public void validateExpr(SqlNode expr) {
        SqlNode expanded = this.validator.expandOrderExpr(this.select, expr);
        this.parent.validateExpr(expanded);
    }
}

