/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql2rel;

import com.hazelcast.com.google.common.base.MoreObjects;
import com.hazelcast.com.google.common.primitives.Booleans;
import com.hazelcast.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.hazelcast.org.apache.calcite.rel.hint.HintStrategyTable;
import com.hazelcast.org.apache.calcite.sql2rel.SqlToRelConverter;
import com.hazelcast.org.apache.calcite.tools.RelBuilder;
import com.hazelcast.org.apache.calcite.tools.RelBuilderFactory;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.UnaryOperator;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SqlToRelConverter", generator="Immutables")
final class ImmutableSqlToRelConverter {
    private ImmutableSqlToRelConverter() {
    }

    @CheckReturnValue
    @Generated(from="SqlToRelConverter.Config", generator="Immutables")
    @Immutable
    static final class Config
    implements SqlToRelConverter.Config {
        private final boolean decorrelationEnabled;
        private final boolean trimUnusedFields;
        private final boolean createValuesRel;
        private final boolean explain;
        private final boolean expand;
        private final int inSubQueryThreshold;
        private final boolean removeSortInSubQuery;
        private final RelBuilderFactory relBuilderFactory;
        private final UnaryOperator<RelBuilder.Config> relBuilderConfigTransform;
        private final HintStrategyTable hintStrategyTable;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private Config(Builder builder) {
            this.relBuilderFactory = builder.relBuilderFactory;
            this.relBuilderConfigTransform = builder.relBuilderConfigTransform;
            this.hintStrategyTable = builder.hintStrategyTable;
            if (builder.decorrelationEnabledIsSet()) {
                this.initShim.withDecorrelationEnabled(builder.decorrelationEnabled);
            }
            if (builder.trimUnusedFieldsIsSet()) {
                this.initShim.withTrimUnusedFields(builder.trimUnusedFields);
            }
            if (builder.createValuesRelIsSet()) {
                this.initShim.withCreateValuesRel(builder.createValuesRel);
            }
            if (builder.explainIsSet()) {
                this.initShim.withExplain(builder.explain);
            }
            if (builder.expandIsSet()) {
                this.initShim.withExpand(builder.expand);
            }
            if (builder.inSubQueryThresholdIsSet()) {
                this.initShim.withInSubQueryThreshold(builder.inSubQueryThreshold);
            }
            if (builder.removeSortInSubQueryIsSet()) {
                this.initShim.withRemoveSortInSubQuery(builder.removeSortInSubQuery);
            }
            this.decorrelationEnabled = this.initShim.isDecorrelationEnabled();
            this.trimUnusedFields = this.initShim.isTrimUnusedFields();
            this.createValuesRel = this.initShim.isCreateValuesRel();
            this.explain = this.initShim.isExplain();
            this.expand = this.initShim.isExpand();
            this.inSubQueryThreshold = this.initShim.getInSubQueryThreshold();
            this.removeSortInSubQuery = this.initShim.isRemoveSortInSubQuery();
            this.initShim = null;
        }

        private Config(boolean decorrelationEnabled, boolean trimUnusedFields, boolean createValuesRel, boolean explain, boolean expand, int inSubQueryThreshold, boolean removeSortInSubQuery, RelBuilderFactory relBuilderFactory, UnaryOperator<RelBuilder.Config> relBuilderConfigTransform, HintStrategyTable hintStrategyTable) {
            this.decorrelationEnabled = decorrelationEnabled;
            this.trimUnusedFields = trimUnusedFields;
            this.createValuesRel = createValuesRel;
            this.explain = explain;
            this.expand = expand;
            this.inSubQueryThreshold = inSubQueryThreshold;
            this.removeSortInSubQuery = removeSortInSubQuery;
            this.relBuilderFactory = relBuilderFactory;
            this.relBuilderConfigTransform = relBuilderConfigTransform;
            this.hintStrategyTable = hintStrategyTable;
            this.initShim = null;
        }

        private boolean isDecorrelationEnabledInitialize() {
            return SqlToRelConverter.Config.super.isDecorrelationEnabled();
        }

        private boolean isTrimUnusedFieldsInitialize() {
            return SqlToRelConverter.Config.super.isTrimUnusedFields();
        }

        private boolean isCreateValuesRelInitialize() {
            return SqlToRelConverter.Config.super.isCreateValuesRel();
        }

        private boolean isExplainInitialize() {
            return SqlToRelConverter.Config.super.isExplain();
        }

        private boolean isExpandInitialize() {
            return SqlToRelConverter.Config.super.isExpand();
        }

        private int getInSubQueryThresholdInitialize() {
            return SqlToRelConverter.Config.super.getInSubQueryThreshold();
        }

        private boolean isRemoveSortInSubQueryInitialize() {
            return SqlToRelConverter.Config.super.isRemoveSortInSubQuery();
        }

        @Override
        public boolean isDecorrelationEnabled() {
            InitShim shim = this.initShim;
            return shim != null ? shim.isDecorrelationEnabled() : this.decorrelationEnabled;
        }

        @Override
        public boolean isTrimUnusedFields() {
            InitShim shim = this.initShim;
            return shim != null ? shim.isTrimUnusedFields() : this.trimUnusedFields;
        }

        @Override
        public boolean isCreateValuesRel() {
            InitShim shim = this.initShim;
            return shim != null ? shim.isCreateValuesRel() : this.createValuesRel;
        }

        @Override
        public boolean isExplain() {
            InitShim shim = this.initShim;
            return shim != null ? shim.isExplain() : this.explain;
        }

        @Override
        public boolean isExpand() {
            InitShim shim = this.initShim;
            return shim != null ? shim.isExpand() : this.expand;
        }

        @Override
        public int getInSubQueryThreshold() {
            InitShim shim = this.initShim;
            return shim != null ? shim.getInSubQueryThreshold() : this.inSubQueryThreshold;
        }

        @Override
        public boolean isRemoveSortInSubQuery() {
            InitShim shim = this.initShim;
            return shim != null ? shim.isRemoveSortInSubQuery() : this.removeSortInSubQuery;
        }

        @Override
        public RelBuilderFactory getRelBuilderFactory() {
            return this.relBuilderFactory;
        }

        @Override
        public UnaryOperator<RelBuilder.Config> getRelBuilderConfigTransform() {
            return this.relBuilderConfigTransform;
        }

        @Override
        public HintStrategyTable getHintStrategyTable() {
            return this.hintStrategyTable;
        }

        @Override
        public final Config withDecorrelationEnabled(boolean value) {
            if (this.decorrelationEnabled == value) {
                return this;
            }
            return new Config(value, this.trimUnusedFields, this.createValuesRel, this.explain, this.expand, this.inSubQueryThreshold, this.removeSortInSubQuery, this.relBuilderFactory, this.relBuilderConfigTransform, this.hintStrategyTable);
        }

        @Override
        public final Config withTrimUnusedFields(boolean value) {
            if (this.trimUnusedFields == value) {
                return this;
            }
            return new Config(this.decorrelationEnabled, value, this.createValuesRel, this.explain, this.expand, this.inSubQueryThreshold, this.removeSortInSubQuery, this.relBuilderFactory, this.relBuilderConfigTransform, this.hintStrategyTable);
        }

        @Override
        public final Config withCreateValuesRel(boolean value) {
            if (this.createValuesRel == value) {
                return this;
            }
            return new Config(this.decorrelationEnabled, this.trimUnusedFields, value, this.explain, this.expand, this.inSubQueryThreshold, this.removeSortInSubQuery, this.relBuilderFactory, this.relBuilderConfigTransform, this.hintStrategyTable);
        }

        @Override
        public final Config withExplain(boolean value) {
            if (this.explain == value) {
                return this;
            }
            return new Config(this.decorrelationEnabled, this.trimUnusedFields, this.createValuesRel, value, this.expand, this.inSubQueryThreshold, this.removeSortInSubQuery, this.relBuilderFactory, this.relBuilderConfigTransform, this.hintStrategyTable);
        }

        @Override
        public final Config withExpand(boolean value) {
            if (this.expand == value) {
                return this;
            }
            return new Config(this.decorrelationEnabled, this.trimUnusedFields, this.createValuesRel, this.explain, value, this.inSubQueryThreshold, this.removeSortInSubQuery, this.relBuilderFactory, this.relBuilderConfigTransform, this.hintStrategyTable);
        }

        @Override
        public final Config withInSubQueryThreshold(int value) {
            if (this.inSubQueryThreshold == value) {
                return this;
            }
            return new Config(this.decorrelationEnabled, this.trimUnusedFields, this.createValuesRel, this.explain, this.expand, value, this.removeSortInSubQuery, this.relBuilderFactory, this.relBuilderConfigTransform, this.hintStrategyTable);
        }

        @Override
        public final Config withRemoveSortInSubQuery(boolean value) {
            if (this.removeSortInSubQuery == value) {
                return this;
            }
            return new Config(this.decorrelationEnabled, this.trimUnusedFields, this.createValuesRel, this.explain, this.expand, this.inSubQueryThreshold, value, this.relBuilderFactory, this.relBuilderConfigTransform, this.hintStrategyTable);
        }

        @Override
        public final Config withRelBuilderFactory(RelBuilderFactory value) {
            if (this.relBuilderFactory == value) {
                return this;
            }
            RelBuilderFactory newValue = Objects.requireNonNull(value, "relBuilderFactory");
            return new Config(this.decorrelationEnabled, this.trimUnusedFields, this.createValuesRel, this.explain, this.expand, this.inSubQueryThreshold, this.removeSortInSubQuery, newValue, this.relBuilderConfigTransform, this.hintStrategyTable);
        }

        @Override
        public final Config withRelBuilderConfigTransform(UnaryOperator<RelBuilder.Config> value) {
            if (this.relBuilderConfigTransform == value) {
                return this;
            }
            UnaryOperator<RelBuilder.Config> newValue = Objects.requireNonNull(value, "relBuilderConfigTransform");
            return new Config(this.decorrelationEnabled, this.trimUnusedFields, this.createValuesRel, this.explain, this.expand, this.inSubQueryThreshold, this.removeSortInSubQuery, this.relBuilderFactory, newValue, this.hintStrategyTable);
        }

        @Override
        public final Config withHintStrategyTable(HintStrategyTable value) {
            if (this.hintStrategyTable == value) {
                return this;
            }
            HintStrategyTable newValue = Objects.requireNonNull(value, "hintStrategyTable");
            return new Config(this.decorrelationEnabled, this.trimUnusedFields, this.createValuesRel, this.explain, this.expand, this.inSubQueryThreshold, this.removeSortInSubQuery, this.relBuilderFactory, this.relBuilderConfigTransform, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Config && this.equalTo((Config)another);
        }

        private boolean equalTo(Config another) {
            return this.decorrelationEnabled == another.decorrelationEnabled && this.trimUnusedFields == another.trimUnusedFields && this.createValuesRel == another.createValuesRel && this.explain == another.explain && this.expand == another.expand && this.inSubQueryThreshold == another.inSubQueryThreshold && this.removeSortInSubQuery == another.removeSortInSubQuery && this.relBuilderFactory.equals(another.relBuilderFactory) && this.relBuilderConfigTransform.equals(another.relBuilderConfigTransform) && this.hintStrategyTable.equals(another.hintStrategyTable);
        }

        public int hashCode() {
            int h2 = 5381;
            h2 += (h2 << 5) + Booleans.hashCode(this.decorrelationEnabled);
            h2 += (h2 << 5) + Booleans.hashCode(this.trimUnusedFields);
            h2 += (h2 << 5) + Booleans.hashCode(this.createValuesRel);
            h2 += (h2 << 5) + Booleans.hashCode(this.explain);
            h2 += (h2 << 5) + Booleans.hashCode(this.expand);
            h2 += (h2 << 5) + this.inSubQueryThreshold;
            h2 += (h2 << 5) + Booleans.hashCode(this.removeSortInSubQuery);
            h2 += (h2 << 5) + this.relBuilderFactory.hashCode();
            h2 += (h2 << 5) + this.relBuilderConfigTransform.hashCode();
            h2 += (h2 << 5) + this.hintStrategyTable.hashCode();
            return h2;
        }

        public String toString() {
            return MoreObjects.toStringHelper("Config").omitNullValues().add("decorrelationEnabled", this.decorrelationEnabled).add("trimUnusedFields", this.trimUnusedFields).add("createValuesRel", this.createValuesRel).add("explain", this.explain).add("expand", this.expand).add("inSubQueryThreshold", this.inSubQueryThreshold).add("removeSortInSubQuery", this.removeSortInSubQuery).add("relBuilderFactory", this.relBuilderFactory).add("relBuilderConfigTransform", this.relBuilderConfigTransform).add("hintStrategyTable", this.hintStrategyTable).toString();
        }

        public static Config copyOf(SqlToRelConverter.Config instance) {
            if (instance instanceof Config) {
                return (Config)instance;
            }
            return Config.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="SqlToRelConverter.Config", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_REL_BUILDER_FACTORY = 1L;
            private static final long INIT_BIT_REL_BUILDER_CONFIG_TRANSFORM = 2L;
            private static final long INIT_BIT_HINT_STRATEGY_TABLE = 4L;
            private static final long OPT_BIT_DECORRELATION_ENABLED = 1L;
            private static final long OPT_BIT_TRIM_UNUSED_FIELDS = 2L;
            private static final long OPT_BIT_CREATE_VALUES_REL = 4L;
            private static final long OPT_BIT_EXPLAIN = 8L;
            private static final long OPT_BIT_EXPAND = 16L;
            private static final long OPT_BIT_IN_SUB_QUERY_THRESHOLD = 32L;
            private static final long OPT_BIT_REMOVE_SORT_IN_SUB_QUERY = 64L;
            private long initBits = 7L;
            private long optBits;
            private boolean decorrelationEnabled;
            private boolean trimUnusedFields;
            private boolean createValuesRel;
            private boolean explain;
            private boolean expand;
            private int inSubQueryThreshold;
            private boolean removeSortInSubQuery;
            @Nullable
            private RelBuilderFactory relBuilderFactory;
            @Nullable
            private UnaryOperator<RelBuilder.Config> relBuilderConfigTransform;
            @Nullable
            private HintStrategyTable hintStrategyTable;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(SqlToRelConverter.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.withDecorrelationEnabled(instance.isDecorrelationEnabled());
                this.withTrimUnusedFields(instance.isTrimUnusedFields());
                this.withCreateValuesRel(instance.isCreateValuesRel());
                this.withExplain(instance.isExplain());
                this.withExpand(instance.isExpand());
                this.withInSubQueryThreshold(instance.getInSubQueryThreshold());
                this.withRemoveSortInSubQuery(instance.isRemoveSortInSubQuery());
                this.withRelBuilderFactory(instance.getRelBuilderFactory());
                this.withRelBuilderConfigTransform(instance.getRelBuilderConfigTransform());
                this.withHintStrategyTable(instance.getHintStrategyTable());
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withDecorrelationEnabled(boolean decorrelationEnabled) {
                this.decorrelationEnabled = decorrelationEnabled;
                this.optBits |= 1L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withTrimUnusedFields(boolean trimUnusedFields) {
                this.trimUnusedFields = trimUnusedFields;
                this.optBits |= 2L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withCreateValuesRel(boolean createValuesRel) {
                this.createValuesRel = createValuesRel;
                this.optBits |= 4L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withExplain(boolean explain) {
                this.explain = explain;
                this.optBits |= 8L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withExpand(boolean expand) {
                this.expand = expand;
                this.optBits |= 0x10L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withInSubQueryThreshold(int inSubQueryThreshold) {
                this.inSubQueryThreshold = inSubQueryThreshold;
                this.optBits |= 0x20L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withRemoveSortInSubQuery(boolean removeSortInSubQuery) {
                this.removeSortInSubQuery = removeSortInSubQuery;
                this.optBits |= 0x40L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.relBuilderFactory = Objects.requireNonNull(relBuilderFactory, "relBuilderFactory");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withRelBuilderConfigTransform(UnaryOperator<RelBuilder.Config> relBuilderConfigTransform) {
                this.relBuilderConfigTransform = Objects.requireNonNull(relBuilderConfigTransform, "relBuilderConfigTransform");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withHintStrategyTable(HintStrategyTable hintStrategyTable) {
                this.hintStrategyTable = Objects.requireNonNull(hintStrategyTable, "hintStrategyTable");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public Config build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Config(this);
            }

            private boolean decorrelationEnabledIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private boolean trimUnusedFieldsIsSet() {
                return (this.optBits & 2L) != 0L;
            }

            private boolean createValuesRelIsSet() {
                return (this.optBits & 4L) != 0L;
            }

            private boolean explainIsSet() {
                return (this.optBits & 8L) != 0L;
            }

            private boolean expandIsSet() {
                return (this.optBits & 0x10L) != 0L;
            }

            private boolean inSubQueryThresholdIsSet() {
                return (this.optBits & 0x20L) != 0L;
            }

            private boolean removeSortInSubQueryIsSet() {
                return (this.optBits & 0x40L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("relBuilderFactory");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("relBuilderConfigTransform");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("hintStrategyTable");
                }
                return "Cannot build Config, some of required attributes are not set " + attributes;
            }
        }

        @Generated(from="SqlToRelConverter.Config", generator="Immutables")
        private final class InitShim {
            private byte decorrelationEnabledBuildStage = 0;
            private boolean decorrelationEnabled;
            private byte trimUnusedFieldsBuildStage = 0;
            private boolean trimUnusedFields;
            private byte createValuesRelBuildStage = 0;
            private boolean createValuesRel;
            private byte explainBuildStage = 0;
            private boolean explain;
            private byte expandBuildStage = 0;
            private boolean expand;
            private byte inSubQueryThresholdBuildStage = 0;
            private int inSubQueryThreshold;
            private byte removeSortInSubQueryBuildStage = 0;
            private boolean removeSortInSubQuery;

            private InitShim() {
            }

            boolean isDecorrelationEnabled() {
                if (this.decorrelationEnabledBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.decorrelationEnabledBuildStage == 0) {
                    this.decorrelationEnabledBuildStage = (byte)-1;
                    this.decorrelationEnabled = Config.this.isDecorrelationEnabledInitialize();
                    this.decorrelationEnabledBuildStage = 1;
                }
                return this.decorrelationEnabled;
            }

            void withDecorrelationEnabled(boolean decorrelationEnabled) {
                this.decorrelationEnabled = decorrelationEnabled;
                this.decorrelationEnabledBuildStage = 1;
            }

            boolean isTrimUnusedFields() {
                if (this.trimUnusedFieldsBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.trimUnusedFieldsBuildStage == 0) {
                    this.trimUnusedFieldsBuildStage = (byte)-1;
                    this.trimUnusedFields = Config.this.isTrimUnusedFieldsInitialize();
                    this.trimUnusedFieldsBuildStage = 1;
                }
                return this.trimUnusedFields;
            }

            void withTrimUnusedFields(boolean trimUnusedFields) {
                this.trimUnusedFields = trimUnusedFields;
                this.trimUnusedFieldsBuildStage = 1;
            }

            boolean isCreateValuesRel() {
                if (this.createValuesRelBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.createValuesRelBuildStage == 0) {
                    this.createValuesRelBuildStage = (byte)-1;
                    this.createValuesRel = Config.this.isCreateValuesRelInitialize();
                    this.createValuesRelBuildStage = 1;
                }
                return this.createValuesRel;
            }

            void withCreateValuesRel(boolean createValuesRel) {
                this.createValuesRel = createValuesRel;
                this.createValuesRelBuildStage = 1;
            }

            boolean isExplain() {
                if (this.explainBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.explainBuildStage == 0) {
                    this.explainBuildStage = (byte)-1;
                    this.explain = Config.this.isExplainInitialize();
                    this.explainBuildStage = 1;
                }
                return this.explain;
            }

            void withExplain(boolean explain) {
                this.explain = explain;
                this.explainBuildStage = 1;
            }

            boolean isExpand() {
                if (this.expandBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.expandBuildStage == 0) {
                    this.expandBuildStage = (byte)-1;
                    this.expand = Config.this.isExpandInitialize();
                    this.expandBuildStage = 1;
                }
                return this.expand;
            }

            void withExpand(boolean expand) {
                this.expand = expand;
                this.expandBuildStage = 1;
            }

            int getInSubQueryThreshold() {
                if (this.inSubQueryThresholdBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.inSubQueryThresholdBuildStage == 0) {
                    this.inSubQueryThresholdBuildStage = (byte)-1;
                    this.inSubQueryThreshold = Config.this.getInSubQueryThresholdInitialize();
                    this.inSubQueryThresholdBuildStage = 1;
                }
                return this.inSubQueryThreshold;
            }

            void withInSubQueryThreshold(int inSubQueryThreshold) {
                this.inSubQueryThreshold = inSubQueryThreshold;
                this.inSubQueryThresholdBuildStage = 1;
            }

            boolean isRemoveSortInSubQuery() {
                if (this.removeSortInSubQueryBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.removeSortInSubQueryBuildStage == 0) {
                    this.removeSortInSubQueryBuildStage = (byte)-1;
                    this.removeSortInSubQuery = Config.this.isRemoveSortInSubQueryInitialize();
                    this.removeSortInSubQueryBuildStage = 1;
                }
                return this.removeSortInSubQuery;
            }

            void withRemoveSortInSubQuery(boolean removeSortInSubQuery) {
                this.removeSortInSubQuery = removeSortInSubQuery;
                this.removeSortInSubQueryBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.decorrelationEnabledBuildStage == -1) {
                    attributes.add("decorrelationEnabled");
                }
                if (this.trimUnusedFieldsBuildStage == -1) {
                    attributes.add("trimUnusedFields");
                }
                if (this.createValuesRelBuildStage == -1) {
                    attributes.add("createValuesRel");
                }
                if (this.explainBuildStage == -1) {
                    attributes.add("explain");
                }
                if (this.expandBuildStage == -1) {
                    attributes.add("expand");
                }
                if (this.inSubQueryThresholdBuildStage == -1) {
                    attributes.add("inSubQueryThreshold");
                }
                if (this.removeSortInSubQueryBuildStage == -1) {
                    attributes.add("removeSortInSubQuery");
                }
                return "Cannot build Config, attribute initializers form cycle " + attributes;
            }
        }
    }
}

