/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.util;

import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class DelegatingInvocationHandler
implements InvocationHandler {
    @Override
    public @Nullable Object invoke(Object proxy, Method method, @Nullable Object[] args) throws Throwable {
        Method matchingMethod;
        Class<?> clazz = this.getClass();
        try {
            matchingMethod = clazz.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException | SecurityException e) {
            matchingMethod = null;
        }
        try {
            if (matchingMethod != null) {
                return matchingMethod.invoke((Object)this, args);
            }
            return method.invoke(this.getTarget(), args);
        }
        catch (InvocationTargetException e) {
            throw (Throwable)Util.first(e.getCause(), e);
        }
    }

    protected abstract Object getTarget();
}

