/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.util;

import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlCharStringLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.fun.SqlLibraryOperators;
import com.hazelcast.org.apache.calcite.sql.fun.SqlTrimFunction;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import java.util.Objects;

public abstract class RelToSqlConverterUtil {
    public static void unparseHiveTrim(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlLiteral valueToTrim = (SqlLiteral)call.operand(1);
        String value = Objects.requireNonNull(valueToTrim.toValue(), () -> "call.operand(1).toValue() for call " + call);
        if (value.matches("\\s+")) {
            RelToSqlConverterUtil.unparseTrimWithSpace(writer, call, leftPrec, rightPrec);
        } else {
            SqlLiteral trimFlag = (SqlLiteral)call.operand(0);
            SqlCharStringLiteral regexNode = RelToSqlConverterUtil.createRegexPatternLiteral(call.operand(1), trimFlag);
            SqlCharStringLiteral blankLiteral = SqlLiteral.createCharString("", call.getParserPosition());
            SqlNode[] trimOperands = new SqlNode[]{call.operand(2), regexNode, blankLiteral};
            SqlCall regexReplaceCall = SqlLibraryOperators.REGEXP_REPLACE.createCall(SqlParserPos.ZERO, trimOperands);
            regexReplaceCall.unparse(writer, leftPrec, rightPrec);
        }
    }

    private static void unparseTrimWithSpace(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        String operatorName;
        SqlLiteral trimFlag = (SqlLiteral)call.operand(0);
        switch (trimFlag.getValueAs(SqlTrimFunction.Flag.class)) {
            case LEADING: {
                operatorName = "LTRIM";
                break;
            }
            case TRAILING: {
                operatorName = "RTRIM";
                break;
            }
            default: {
                operatorName = call.getOperator().getName();
            }
        }
        SqlWriter.Frame trimFrame = writer.startFunCall(operatorName);
        ((SqlNode)call.operand(2)).unparse(writer, leftPrec, rightPrec);
        writer.endFunCall(trimFrame);
    }

    public static SqlCharStringLiteral createRegexPatternLiteral(SqlNode call, SqlLiteral trimFlag) {
        String regexPattern = Objects.requireNonNull(((SqlCharStringLiteral)call).toValue(), () -> "null value for SqlNode " + call);
        String escaped = RelToSqlConverterUtil.escapeSpecialChar(regexPattern);
        StringBuilder builder = new StringBuilder();
        switch (trimFlag.getValueAs(SqlTrimFunction.Flag.class)) {
            case LEADING: {
                builder.append("^(").append(escaped).append(")*");
                break;
            }
            case TRAILING: {
                builder.append("(").append(escaped).append(")*$");
                break;
            }
            default: {
                builder.append("^(").append(escaped).append(")*|(").append(escaped).append(")*$");
            }
        }
        return SqlLiteral.createCharString(builder.toString(), call.getParserPosition());
    }

    private static String escapeSpecialChar(String inputString) {
        String[] specialCharacters;
        for (String specialCharacter : specialCharacters = new String[]{"\\", "^", "$", "{", "}", "[", "]", "(", ")", ".", "*", "+", "?", "|", "<", ">", "-", "&", "%", "@"}) {
            if (!inputString.contains(specialCharacter)) continue;
            inputString = inputString.replace(specialCharacter, "\\" + specialCharacter);
        }
        return inputString;
    }

    public static SqlSpecialOperator specialOperatorByName(String opName) {
        return new SqlSpecialOperator(opName, SqlKind.OTHER_FUNCTION){

            @Override
            public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
                writer.print(this.getName());
                SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.FUN_CALL, "(", ")");
                for (SqlNode operand : call.getOperandList()) {
                    writer.sep(",");
                    operand.unparse(writer, 0, 0);
                }
                writer.endList(frame);
            }
        };
    }
}

