/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.file;

import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.jet.sql.impl.connector.file.FileSqlConnector;
import com.hazelcast.jet.sql.impl.schema.HazelcastDynamicTableFunction;
import com.hazelcast.jet.sql.impl.schema.HazelcastSqlOperandMetadata;
import com.hazelcast.jet.sql.impl.schema.HazelcastTableFunctionParameter;
import com.hazelcast.jet.sql.impl.validate.HazelcastCallBinding;
import com.hazelcast.jet.sql.impl.validate.operand.TypedOperandChecker;
import com.hazelcast.jet.sql.impl.validate.operators.typeinference.HazelcastOperandTypeInference;
import com.hazelcast.jet.sql.impl.validate.operators.typeinference.ReplaceUnknownOperandTypeInference;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.Table;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class FileTableFunction
extends HazelcastDynamicTableFunction {
    private static final String SCHEMA_NAME_FILES = "files";
    private static final List<HazelcastTableFunctionParameter> PARAMETERS = Arrays.asList(new HazelcastTableFunctionParameter(0, "path", SqlTypeName.VARCHAR, false, TypedOperandChecker.VARCHAR), new HazelcastTableFunctionParameter(1, "glob", SqlTypeName.VARCHAR, true, TypedOperandChecker.VARCHAR), new HazelcastTableFunctionParameter(2, "sharedFileSystem", SqlTypeName.VARCHAR, true, TypedOperandChecker.VARCHAR), new HazelcastTableFunctionParameter(3, "options", SqlTypeName.MAP, true, TypedOperandChecker.MAP));

    public FileTableFunction(String name, String format) {
        super(name, FileOperandMetadata.INSTANCE, (List<Object> arguments) -> FileTableFunction.toTable(arguments, format));
    }

    private static Table toTable(List<Object> arguments, String format) {
        Map<String, Object> options = FileTableFunction.toOptions(arguments, format);
        List<MappingField> fields = FileSqlConnector.resolveAndValidateFields(options, Collections.emptyList());
        return FileSqlConnector.createTable(SCHEMA_NAME_FILES, FileTableFunction.randomName(), options, fields);
    }

    private static Map<String, Object> toOptions(List<Object> arguments, String format) {
        assert (arguments.size() == PARAMETERS.size());
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("format", format);
        for (int i = 0; i < arguments.size(); ++i) {
            if (arguments.get(i) == null) continue;
            options.put(PARAMETERS.get(i).name(), arguments.get(i));
        }
        return options;
    }

    private static String randomName() {
        return "files_" + UuidUtil.newUnsecureUuidString().replace('-', '_');
    }

    private static final class FileOperandMetadata
    extends HazelcastSqlOperandMetadata {
        private static final FileOperandMetadata INSTANCE = new FileOperandMetadata();

        private FileOperandMetadata() {
            super(PARAMETERS, new HazelcastOperandTypeInference(PARAMETERS, new ReplaceUnknownOperandTypeInference(SqlTypeName.ANY)));
        }

        @Override
        protected boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
            return true;
        }
    }
}

