/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.infoschema;

import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.json.JsonUtil;
import com.hazelcast.jet.sql.impl.connector.infoschema.InfoSchemaTable;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.dataconnection.DataConnectionCatalogEntry;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class DataConnectionsTable
extends InfoSchemaTable {
    private static final String NAME = "dataconnections";
    private static final List<TableField> FIELDS = Arrays.asList(new TableField("catalog", QueryDataType.VARCHAR, false), new TableField("schema", QueryDataType.VARCHAR, false), new TableField("name", QueryDataType.VARCHAR, false), new TableField("type", QueryDataType.VARCHAR, false), new TableField("shared", QueryDataType.BOOLEAN, false), new TableField("options", QueryDataType.VARCHAR, false), new TableField("source", QueryDataType.VARCHAR, false));
    private final String dataConnectionSchema;
    private final Collection<DataConnectionCatalogEntry> dataConnectionCatalogEntries;
    private final boolean securityEnabled;

    public DataConnectionsTable(String catalog, String schemaName, String dataConnectionSchema, Collection<DataConnectionCatalogEntry> dataConnectionCatalogEntries, boolean securityEnabled) {
        super(FIELDS, catalog, schemaName, NAME, new ConstantTableStatistics(0L));
        this.dataConnectionSchema = dataConnectionSchema;
        this.dataConnectionCatalogEntries = dataConnectionCatalogEntries;
        this.securityEnabled = securityEnabled;
    }

    @Override
    protected List<Object[]> rows() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>(this.dataConnectionCatalogEntries.size());
        for (DataConnectionCatalogEntry dl : this.dataConnectionCatalogEntries) {
            Object[] row = new Object[]{this.catalog(), this.dataConnectionSchema, dl.name(), dl.type(), dl.isShared(), this.securityEnabled ? null : Util.uncheckCall(() -> JsonUtil.toJson(dl.options())), dl.source().name()};
            rows.add(row);
        }
        return rows;
    }
}

