/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.function.ToResultSetFunction;
import com.hazelcast.jet.impl.connector.ReadJdbcP;
import com.hazelcast.jet.sql.impl.connector.jdbc.AbstractJdbcSqlConnectorProcessorSupplier;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.security.impl.function.SecuredFunction;
import com.hazelcast.security.permission.ConnectorPermission;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.io.IOException;
import java.io.Serializable;
import java.security.Permission;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SelectProcessorSupplier
extends AbstractJdbcSqlConnectorProcessorSupplier
implements ProcessorSupplier,
DataSerializable,
SecuredFunction {
    private static final Map<String, BiFunctionEx<ResultSet, Integer, Object>> GETTERS = new HashMap<String, BiFunctionEx<ResultSet, Integer, Object>>();
    private String query;
    private int[] parameterPositions;
    private transient ExpressionEvalContext evalContext;
    private volatile transient BiFunctionEx<ResultSet, Integer, Object>[] valueGetters;

    public SelectProcessorSupplier() {
    }

    public SelectProcessorSupplier(@Nonnull String dataConnectionName, @Nonnull String query, @Nonnull int[] parameterPositions) {
        super(dataConnectionName);
        this.query = Objects.requireNonNull(query, "query must not be null");
        this.parameterPositions = Objects.requireNonNull(parameterPositions, "parameterPositions must not be null");
    }

    @Override
    public void init(@Nonnull ProcessorSupplier.Context context) throws Exception {
        super.init(context);
        this.evalContext = ExpressionEvalContext.from(context);
    }

    @Nonnull
    public Collection<? extends Processor> get(int count) {
        assert (count == 1);
        ReadJdbcP processor = new ReadJdbcP((SupplierEx & Serializable)() -> this.dataConnection.getConnection(), (ToResultSetFunction & Serializable)(connection, parallelism, index) -> {
            PreparedStatement statement = connection.prepareStatement(this.query);
            List<Object> arguments = this.evalContext.getArguments();
            for (int j = 0; j < this.parameterPositions.length; ++j) {
                statement.setObject(j + 1, arguments.get(this.parameterPositions[j]));
            }
            try {
                ResultSet rs = statement.executeQuery();
                this.valueGetters = this.prepareValueGettersFromMetadata(rs);
                return rs;
            }
            catch (SQLException e) {
                statement.close();
                throw e;
            }
        }, (FunctionEx & Serializable)rs -> {
            int columnCount = rs.getMetaData().getColumnCount();
            Object[] row = new Object[columnCount];
            for (int j = 0; j < columnCount; ++j) {
                Object value;
                row[j] = value = this.valueGetters[j].apply(rs, (Object)(j + 1));
            }
            return new JetSqlRow((SerializationService)this.evalContext.getSerializationService(), row);
        });
        return Collections.singleton(processor);
    }

    private BiFunctionEx<ResultSet, Integer, Object>[] prepareValueGettersFromMetadata(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        BiFunctionEx[] valueGetters = new BiFunctionEx[metaData.getColumnCount()];
        for (int j = 0; j < metaData.getColumnCount(); ++j) {
            String type = metaData.getColumnTypeName(j + 1).toUpperCase(Locale.ROOT);
            valueGetters[j] = GETTERS.getOrDefault(type, (BiFunctionEx<ResultSet, Integer, Object>)(BiFunctionEx & Serializable)(resultSet, n) -> rs.getObject((int)n));
        }
        return valueGetters;
    }

    @Nullable
    public List<Permission> permissions() {
        return Collections.singletonList(ConnectorPermission.jdbc((String)this.dataConnectionName, (String)"read"));
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.dataConnectionName);
        out.writeString(this.query);
        out.writeIntArray(this.parameterPositions);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.dataConnectionName = in.readString();
        this.query = in.readString();
        this.parameterPositions = in.readIntArray();
    }

    static {
        GETTERS.put("BOOLEAN", (BiFunctionEx<ResultSet, Integer, Object>)((BiFunctionEx & Serializable)ResultSet::getBoolean));
        GETTERS.put("BOOL", (BiFunctionEx<ResultSet, Integer, Object>)((BiFunctionEx & Serializable)ResultSet::getBoolean));
        GETTERS.put("BIT", (BiFunctionEx<ResultSet, Integer, Object>)((BiFunctionEx & Serializable)ResultSet::getBoolean));
        GETTERS.put("TINYINT", (BiFunctionEx<ResultSet, Integer, Object>)((BiFunctionEx & Serializable)ResultSet::getByte));
        GETTERS.put("SMALLINT", (BiFunctionEx<ResultSet, Integer, Object>)((BiFunctionEx & Serializable)ResultSet::getShort));
        GETTERS.put("INT2", (BiFunctionEx<ResultSet, Integer, Object>)((BiFunctionEx & Serializable)ResultSet::getShort));
        GETTERS.put("INT", (BiFunctionEx<ResultSet, Integer, Object>)((BiFunctionEx & Serializable)ResultSet::getInt));
        GETTERS.put("INT4", (BiFunctionEx<ResultSet, Integer, Object>)((BiFunctionEx & Serializable)ResultSet::getInt));
        GETTERS.put("INTEGER", (BiFunctionEx<ResultSet, Integer, Object>)((BiFunctionEx & Serializable)ResultSet::getInt));
        GETTERS.put("INT8", (BiFunctionEx<ResultSet, Integer, Object>)((BiFunctionEx & Serializable)ResultSet::getLong));
        GETTERS.put("BIGINT", (BiFunctionEx<ResultSet, Integer, Object>)((BiFunctionEx & Serializable)ResultSet::getLong));
        GETTERS.put("VARCHAR", (BiFunctionEx<ResultSet, Integer, Object>)((BiFunctionEx & Serializable)ResultSet::getString));
        GETTERS.put("CHARACTER VARYING", (BiFunctionEx<ResultSet, Integer, Object>)((BiFunctionEx & Serializable)ResultSet::getString));
        GETTERS.put("TEXT", (BiFunctionEx<ResultSet, Integer, Object>)((BiFunctionEx & Serializable)ResultSet::getString));
        GETTERS.put("REAL", (BiFunctionEx<ResultSet, Integer, Object>)((BiFunctionEx & Serializable)ResultSet::getFloat));
        GETTERS.put("FLOAT", (BiFunctionEx<ResultSet, Integer, Object>)((BiFunctionEx & Serializable)ResultSet::getFloat));
        GETTERS.put("FLOAT4", (BiFunctionEx<ResultSet, Integer, Object>)((BiFunctionEx & Serializable)ResultSet::getFloat));
        GETTERS.put("DOUBLE", (BiFunctionEx<ResultSet, Integer, Object>)((BiFunctionEx & Serializable)ResultSet::getDouble));
        GETTERS.put("DOUBLE PRECISION", (BiFunctionEx<ResultSet, Integer, Object>)((BiFunctionEx & Serializable)ResultSet::getDouble));
        GETTERS.put("DECIMAL", (BiFunctionEx<ResultSet, Integer, Object>)((BiFunctionEx & Serializable)ResultSet::getBigDecimal));
        GETTERS.put("NUMERIC", (BiFunctionEx<ResultSet, Integer, Object>)((BiFunctionEx & Serializable)ResultSet::getBigDecimal));
        GETTERS.put("DATE", (BiFunctionEx<ResultSet, Integer, Object>)(BiFunctionEx & Serializable)(rs, columnIndex) -> rs.getObject((int)columnIndex, LocalDate.class));
        GETTERS.put("TIME", (BiFunctionEx<ResultSet, Integer, Object>)(BiFunctionEx & Serializable)(rs, columnIndex) -> rs.getObject((int)columnIndex, LocalTime.class));
        GETTERS.put("TIMESTAMP", (BiFunctionEx<ResultSet, Integer, Object>)(BiFunctionEx & Serializable)(rs, columnIndex) -> rs.getObject((int)columnIndex, LocalDateTime.class));
        GETTERS.put("TIMESTAMP_WITH_TIMEZONE", (BiFunctionEx<ResultSet, Integer, Object>)(BiFunctionEx & Serializable)(rs, columnIndex) -> rs.getObject((int)columnIndex, OffsetDateTime.class));
    }
}

