/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.processor.TransformBatchedP;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.jet.sql.impl.connector.map.QueryUtil;
import com.hazelcast.map.IMap;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.projection.Projection;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

@SuppressFBWarnings(value={"SE_BAD_FIELD", "SE_NO_SERIALVERSIONID"}, justification="the class is never java-serialized")
final class JoinScanProcessorSupplier
implements ProcessorSupplier,
DataSerializable {
    private JetJoinInfo joinInfo;
    private String mapName;
    private KvRowProjector.Supplier rightRowProjectorSupplier;
    private transient IMap<Object, Object> map;
    private transient ExpressionEvalContext evalContext;

    private JoinScanProcessorSupplier() {
    }

    JoinScanProcessorSupplier(JetJoinInfo joinInfo, String mapName, KvRowProjector.Supplier rightRowProjectorSupplier) {
        this.joinInfo = joinInfo;
        this.mapName = mapName;
        this.rightRowProjectorSupplier = rightRowProjectorSupplier;
    }

    public void init(@Nonnull ProcessorSupplier.Context context) {
        this.map = context.hazelcastInstance().getMap(this.mapName);
        this.evalContext = ExpressionEvalContext.from(context);
    }

    @Nonnull
    public Collection<? extends Processor> get(int count) {
        ArrayList<1> processors = new ArrayList<1>(count);
        for (int i = 0; i < count; ++i) {
            TransformBatchedP<JetSqlRow, JetSqlRow> processor = new TransformBatchedP<JetSqlRow, JetSqlRow>(JoinScanProcessorSupplier.joinFn(this.joinInfo, this.map, this.rightRowProjectorSupplier, this.evalContext)){

                public boolean isCooperative() {
                    return false;
                }
            };
            processors.add(processor);
        }
        return processors;
    }

    private static FunctionEx<Iterable<JetSqlRow>, Traverser<JetSqlRow>> joinFn(@Nonnull JetJoinInfo joinInfo, @Nonnull IMap<Object, Object> map, @Nonnull KvRowProjector.Supplier rightRowProjectorSupplier, @Nonnull ExpressionEvalContext evalContext) {
        Projection<Map.Entry<Object, Object>, JetSqlRow> projection = QueryUtil.toProjection(rightRowProjectorSupplier, evalContext);
        return (FunctionEx & Serializable)lefts -> {
            ArrayList<JetSqlRow> rights = new ArrayList<JetSqlRow>();
            for (JetSqlRow right : map.project(projection)) {
                if (right == null) continue;
                rights.add(right);
            }
            ArrayList<JetSqlRow> rows = new ArrayList<JetSqlRow>();
            for (JetSqlRow left : lefts) {
                boolean joined = JoinScanProcessorSupplier.join(rows, left, rights, joinInfo.condition(), evalContext);
                if (joined || !joinInfo.isLeftOuter()) continue;
                rows.add(left.extendedRow(rightRowProjectorSupplier.columnCount()));
            }
            return Traversers.traverseIterable(rows);
        };
    }

    private static boolean join(@Nonnull List<JetSqlRow> rows, @Nonnull JetSqlRow left, @Nonnull List<JetSqlRow> rights, @Nonnull Expression<Boolean> condition, @Nonnull ExpressionEvalContext evalContext) {
        boolean matched = false;
        for (JetSqlRow right : rights) {
            JetSqlRow joined = ExpressionUtil.join(left, right, condition, evalContext);
            if (joined == null) continue;
            rows.add(joined);
            matched = true;
        }
        return matched;
    }

    public List<Permission> permissions() {
        return Collections.singletonList(new MapPermission(this.mapName, new String[]{"create", "read"}));
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.joinInfo);
        out.writeObject((Object)this.mapName);
        out.writeObject((Object)this.rightRowProjectorSupplier);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.joinInfo = (JetJoinInfo)in.readObject();
        this.mapName = (String)in.readObject();
        this.rightRowProjectorSupplier = (KvRowProjector.Supplier)in.readObject();
    }
}

