/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt;

import com.hazelcast.jet.core.SlidingWindowPolicy;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.SlidingWindowAggregatePhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.StreamToStreamJoinPhysicalRel;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelVisitor;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import javax.annotation.Nullable;

public final class WatermarkThrottlingFrameSizeCalculator {
    static final long S2S_JOIN_MAX_THROTTLING_INTERVAL = 100L;
    static final long PRECISION_DIVIDER = 10L;

    private WatermarkThrottlingFrameSizeCalculator() {
    }

    public static long calculate(PhysicalRel rel, ExpressionEvalContext evalContext) {
        GcdCalculatorVisitor visitor = new GcdCalculatorVisitor(evalContext);
        visitor.go(rel);
        if (visitor.gcd == 0L) {
            return visitor.maximumIntervalForJoins;
        }
        return Math.min(visitor.gcd, visitor.maximumIntervalForJoins);
    }

    private static class GcdCalculatorVisitor
    extends RelVisitor {
        private long gcd;
        private long maximumIntervalForJoins = 100L;
        private ExpressionEvalContext eec;

        GcdCalculatorVisitor(ExpressionEvalContext evalContext) {
            this.eec = evalContext;
        }

        @Override
        public void visit(RelNode node, int ordinal, @Nullable RelNode parent) {
            this.visit0(node);
        }

        private void visit0(RelNode node) {
            if (node instanceof SlidingWindowAggregatePhysicalRel) {
                SlidingWindowAggregatePhysicalRel slidingWindow = (SlidingWindowAggregatePhysicalRel)node;
                long windowSize = ((SlidingWindowPolicy)slidingWindow.windowPolicyProvider().apply((Object)this.eec)).frameSize();
                this.gcd = this.gcd > 0L ? Util.gcd((long)this.gcd, (long)windowSize) : windowSize;
            } else if (node instanceof StreamToStreamJoinPhysicalRel) {
                StreamToStreamJoinPhysicalRel s2sJoin = (StreamToStreamJoinPhysicalRel)node;
                long suggestedInterval = s2sJoin.minimumSpread() / 10L;
                suggestedInterval = Math.max(Math.min(suggestedInterval, 100L), 1L);
                this.maximumIntervalForJoins = Math.min(this.maximumIntervalForJoins, suggestedInterval);
            }
            for (RelNode child : node.getInputs()) {
                this.visit0(child);
            }
        }
    }
}

