/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.cost;

import com.hazelcast.config.IndexType;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeField;

public final class CostUtils {
    public static final double CONSTRAINED_SCAN_CPU_MULTIPLIER = 0.8;
    public static final double TABLE_SCAN_CPU_MULTIPLIER = 1.0;
    public static final double INDEX_SCAN_CPU_MULTIPLIER_SORTED = 1.2;
    public static final double INDEX_SCAN_CPU_MULTIPLIER_HASH = 1.1;
    public static final double CPU_COST_MULTIPLIER = 1.0;
    public static final double NETWORK_COST_MULTIPLIER = 10.0;
    private static final double UNKNOWN_SELECTIVITY = 0.25;

    private CostUtils() {
    }

    public static double indexScanCpuMultiplier(IndexType type) {
        if (type == IndexType.HASH) {
            return 1.1;
        }
        assert (type == IndexType.SORTED);
        return 1.2;
    }

    public static double adjustCpuForConstrainedScan(double cpu) {
        return cpu * 0.8;
    }

    public static Double adjustFilteredRowCount(Double rowCount, Double selectivity) {
        if (rowCount == null) {
            return null;
        }
        if (selectivity == null) {
            selectivity = 0.25;
        }
        return rowCount * selectivity;
    }

    public static double getProjectCpu(double rowCount, int expressionCount) {
        return rowCount * (double)expressionCount;
    }

    public static int getEstimatedRowWidth(RelNode rel) {
        int res = 0;
        for (RelDataTypeField field : rel.getRowType().getFieldList()) {
            res += HazelcastTypeUtils.toHazelcastType(field.getType()).getTypeFamily().getEstimatedSize();
        }
        return res;
    }
}

