/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.opt.Conventions;
import com.hazelcast.jet.sql.impl.opt.SlidingWindow;
import com.hazelcast.jet.sql.impl.opt.logical.ImmutableSlidingWindowJoinTransposeRule;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.shaded.org.apache.calcite.plan.RelRule;
import com.hazelcast.shaded.org.apache.calcite.plan.volcano.RelSubset;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Join;
import com.hazelcast.shaded.org.apache.calcite.rel.rules.TransformationRule;
import java.util.Collections;
import org.immutables.value.Value;

@Value.Enclosing
public class SlidingWindowJoinTransposeRule
extends RelRule<RelRule.Config>
implements TransformationRule {
    public static final RelOptRule STREAMING_JOIN_TRANSPOSE = new SlidingWindowJoinTransposeRule(Config.DEFAULT);

    protected SlidingWindowJoinTransposeRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Join join = (Join)call.rel(0);
        SlidingWindow sw = (SlidingWindow)call.rel(1);
        boolean windowIsLeftInput = ((RelSubset)join.getLeft()).getBest() instanceof SlidingWindow;
        Join newJoin = windowIsLeftInput ? join.copy(join.getTraitSet(), join.getCondition(), sw.getInput(), join.getRight(), join.getJoinType(), join.isSemiJoinDone()) : join.copy(join.getTraitSet(), join.getCondition(), join.getLeft(), sw.getInput(), join.getJoinType(), join.isSemiJoinDone());
        SlidingWindow topSW = (SlidingWindow)sw.copy(sw.getTraitSet(), Collections.singletonList(newJoin));
        call.transformTo(topSW);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableSlidingWindowJoinTransposeRule.Config.builder().description(SlidingWindowJoinTransposeRule.class.getSimpleName()).operandSupplier(b0 -> b0.operand(Join.class).trait(Conventions.LOGICAL).inputs(b1 -> b1.operand(SlidingWindow.class).anyInputs())).build();

        @Override
        default public RelOptRule toRule() {
            return new SlidingWindowJoinTransposeRule(this);
        }
    }
}

