/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.sql.impl.connector.keyvalue.KvProjector;
import com.hazelcast.jet.sql.impl.inject.UpsertTargetDescriptor;
import com.hazelcast.jet.sql.impl.opt.ExpressionValues;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.physical.CreateDagVisitor;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.shaded.org.apache.calcite.rel.AbstractRelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelWriter;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.optimizer.PlanObjectKey;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class InsertMapPhysicalRel
extends AbstractRelNode
implements PhysicalRel {
    private final RelOptTable table;
    private final ExpressionValues values;
    private final int keyParamIndex;

    InsertMapPhysicalRel(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, ExpressionValues values) {
        super(cluster, traitSet);
        assert (table.unwrap(HazelcastTable.class).getTarget() instanceof PartitionedMapTable);
        this.table = table;
        this.values = values;
        this.keyParamIndex = values.getDynamicParamIndex(OptUtils.findPrimaryKeyIndex(this.table()));
    }

    public String mapName() {
        return this.table().getMapName();
    }

    public PlanObjectKey objectKey() {
        return this.table().getObjectKey();
    }

    public Function<ExpressionEvalContext, List<Map.Entry<Object, Object>>> entriesFn() {
        PartitionedMapTable table = this.table();
        ExpressionValues values = this.values;
        return evalContext -> {
            KvProjector projector = KvProjector.supplier(table.paths(), table.types(), (UpsertTargetDescriptor)table.getKeyJetMetadata(), (UpsertTargetDescriptor)table.getValueJetMetadata(), true).get(evalContext.getSerializationService());
            return values.toValues((ExpressionEvalContext)evalContext).map(projector::project).collect(Collectors.toList());
        };
    }

    public int keyParamIndex() {
        return this.keyParamIndex;
    }

    private PartitionedMapTable table() {
        return (PartitionedMapTable)this.table.unwrap(HazelcastTable.class).getTarget();
    }

    @Override
    public PlanNodeSchema schema(QueryParameterMetadata parameterMetadata) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <V> V accept(CreateDagVisitor<V> visitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RelDataType deriveRowType() {
        return RelOptUtil.createDmlRowType(SqlKind.INSERT, this.getCluster().getTypeFactory());
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return pw.item("table", this.table.getQualifiedName()).item("values", this.values);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new InsertMapPhysicalRel(this.getCluster(), traitSet, this.table, this.values);
    }
}

