/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite;

import com.hazelcast.shaded.com.google.common.collect.ImmutableMap;
import com.hazelcast.shaded.org.apache.calcite.DataContext;
import com.hazelcast.shaded.org.apache.calcite.adapter.java.JavaTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.jdbc.CalciteConnection;
import com.hazelcast.shaded.org.apache.calcite.linq4j.QueryProvider;
import com.hazelcast.shaded.org.apache.calcite.schema.SchemaPlus;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class DataContexts {
    public static final DataContext EMPTY = new EmptyDataContext();

    private DataContexts() {
    }

    public static DataContext of(Map<String, ?> map) {
        return new MapDataContext(map);
    }

    public static DataContext of(Function<String, ? extends @Nullable Object> fn) {
        return new FunctionDataContext(fn);
    }

    public static DataContext of(CalciteConnection connection, @Nullable SchemaPlus rootSchema) {
        return new DataContextImpl(connection, rootSchema, ImmutableMap.of());
    }

    private static class DataContextImpl
    extends MapDataContext {
        private CalciteConnection connection;
        private @Nullable SchemaPlus rootSchema;

        DataContextImpl(CalciteConnection connection, @Nullable SchemaPlus rootSchema, Map<String, Object> map) {
            super(map);
            this.connection = Objects.requireNonNull(connection, "connection");
            this.rootSchema = Objects.requireNonNull(rootSchema, "rootSchema");
        }

        @Override
        public JavaTypeFactory getTypeFactory() {
            return this.connection.getTypeFactory();
        }

        @Override
        public @Nullable SchemaPlus getRootSchema() {
            return this.rootSchema;
        }

        @Override
        public QueryProvider getQueryProvider() {
            return this.connection;
        }
    }

    private static class FunctionDataContext
    extends EmptyDataContext {
        private final Function<String, ? extends @Nullable Object> fn;

        FunctionDataContext(Function<String, ? extends @Nullable Object> fn) {
            this.fn = Objects.requireNonNull(fn, "fn");
        }

        @Override
        public @Nullable Object get(String name) {
            return this.fn.apply(name);
        }
    }

    private static class MapDataContext
    extends EmptyDataContext {
        private final ImmutableMap<String, ?> map;

        MapDataContext(Map<String, ?> map) {
            this.map = ImmutableMap.copyOf(map);
        }

        @Override
        public @Nullable Object get(String name) {
            return this.map.get(name);
        }
    }

    private static class EmptyDataContext
    implements DataContext,
    Serializable {
        private EmptyDataContext() {
        }

        @Override
        public @Nullable SchemaPlus getRootSchema() {
            return null;
        }

        @Override
        public JavaTypeFactory getTypeFactory() {
            throw new UnsupportedOperationException();
        }

        @Override
        public QueryProvider getQueryProvider() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable Object get(String name) {
            return null;
        }
    }
}

