/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.materialize;

import com.hazelcast.shaded.com.google.common.base.Suppliers;
import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.DataContexts;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Enumerable;
import com.hazelcast.shaded.org.apache.calcite.materialize.Lattice;
import com.hazelcast.shaded.org.apache.calcite.materialize.LatticeStatisticProvider;
import com.hazelcast.shaded.org.apache.calcite.materialize.MaterializationService;
import com.hazelcast.shaded.org.apache.calcite.profile.Profiler;
import com.hazelcast.shaded.org.apache.calcite.profile.ProfilerImpl;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.NullSentinel;
import com.hazelcast.shaded.org.apache.calcite.schema.ScannableTable;
import com.hazelcast.shaded.org.apache.calcite.schema.Table;
import com.hazelcast.shaded.org.apache.calcite.schema.impl.MaterializedViewTable;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableBitSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

class ProfilerLatticeStatisticProvider
implements LatticeStatisticProvider {
    static final LatticeStatisticProvider.Factory FACTORY = ProfilerLatticeStatisticProvider::new;
    private final Supplier<Profiler.Profile> profile;

    private ProfilerLatticeStatisticProvider(Lattice lattice) {
        Objects.requireNonNull(lattice, "lattice");
        this.profile = Suppliers.memoize(() -> {
            ProfilerImpl profiler = ProfilerImpl.builder().withPassSize(200).withMinimumSurprise(0.3).build();
            ArrayList<Profiler.Column> columns = new ArrayList<Profiler.Column>();
            for (Lattice.Column column : lattice.columns) {
                columns.add(new Profiler.Column(column.ordinal, column.alias));
            }
            String sql = lattice.sql(ImmutableBitSet.range(lattice.columns.size()), false, ImmutableList.of());
            Table table = new MaterializationService.DefaultTableFactory().createTable(lattice.rootSchema, sql, ImmutableList.of());
            ImmutableList<ImmutableBitSet> initialGroups = ImmutableList.of();
            Enumerable<List<Comparable>> rows = ((ScannableTable)table).scan(DataContexts.of(MaterializedViewTable.MATERIALIZATION_CONNECTION, lattice.rootSchema.plus())).select(values -> {
                for (int i = 0; i < ((Object[])values).length; ++i) {
                    if (values[i] != null) continue;
                    values[i] = NullSentinel.INSTANCE;
                }
                return Arrays.asList(values);
            });
            return profiler.profile(rows, columns, initialGroups);
        })::get;
    }

    @Override
    public double cardinality(List<Lattice.Column> columns) {
        ImmutableBitSet build = Lattice.Column.toBitSet(columns);
        double cardinality = this.profile.get().cardinality(build);
        return cardinality;
    }
}

