/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.plan;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.com.google.common.collect.ImmutableMap;
import com.hazelcast.shaded.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.shaded.org.apache.calcite.rex.RexCall;
import com.hazelcast.shaded.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.rex.RexUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.Collection;
import java.util.Objects;

public class RelOptPredicateList {
    private static final ImmutableList<RexNode> EMPTY_LIST = ImmutableList.of();
    public static final RelOptPredicateList EMPTY = new RelOptPredicateList(EMPTY_LIST, EMPTY_LIST, EMPTY_LIST, ImmutableMap.of());
    public final ImmutableList<RexNode> pulledUpPredicates;
    public final ImmutableList<RexNode> leftInferredPredicates;
    public final ImmutableList<RexNode> rightInferredPredicates;
    public final ImmutableMap<RexNode, RexNode> constantMap;

    private RelOptPredicateList(ImmutableList<RexNode> pulledUpPredicates, ImmutableList<RexNode> leftInferredPredicates, ImmutableList<RexNode> rightInferredPredicates, ImmutableMap<RexNode, RexNode> constantMap) {
        this.pulledUpPredicates = Objects.requireNonNull(pulledUpPredicates, "pulledUpPredicates");
        this.leftInferredPredicates = Objects.requireNonNull(leftInferredPredicates, "leftInferredPredicates");
        this.rightInferredPredicates = Objects.requireNonNull(rightInferredPredicates, "rightInferredPredicates");
        this.constantMap = Objects.requireNonNull(constantMap, "constantMap");
    }

    public static RelOptPredicateList of(RexBuilder rexBuilder, Iterable<RexNode> pulledUpPredicates) {
        ImmutableList<RexNode> pulledUpPredicatesList = ImmutableList.copyOf(pulledUpPredicates);
        if (pulledUpPredicatesList.isEmpty()) {
            return EMPTY;
        }
        return RelOptPredicateList.of(rexBuilder, pulledUpPredicatesList, EMPTY_LIST, EMPTY_LIST);
    }

    public static boolean isEmpty(@Nullable RelOptPredicateList value) {
        if (value == null || value == EMPTY) {
            return true;
        }
        return value.constantMap.isEmpty() && value.leftInferredPredicates.isEmpty() && value.rightInferredPredicates.isEmpty() && value.pulledUpPredicates.isEmpty();
    }

    public static RelOptPredicateList of(RexBuilder rexBuilder, Iterable<RexNode> pulledUpPredicates, Iterable<RexNode> leftInferredPredicates, Iterable<RexNode> rightInferredPredicates) {
        ImmutableList<RexNode> pulledUpPredicatesList = ImmutableList.copyOf(pulledUpPredicates);
        ImmutableList<RexNode> leftInferredPredicateList = ImmutableList.copyOf(leftInferredPredicates);
        ImmutableList<RexNode> rightInferredPredicatesList = ImmutableList.copyOf(rightInferredPredicates);
        if (pulledUpPredicatesList.isEmpty() && leftInferredPredicateList.isEmpty() && rightInferredPredicatesList.isEmpty()) {
            return EMPTY;
        }
        ImmutableMap<RexNode, RexNode> constantMap = RexUtil.predicateConstants(RexNode.class, rexBuilder, pulledUpPredicatesList);
        return new RelOptPredicateList(pulledUpPredicatesList, leftInferredPredicateList, rightInferredPredicatesList, constantMap);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("{");
        RelOptPredicateList.append(b, "pulled", this.pulledUpPredicates);
        RelOptPredicateList.append(b, "left", this.leftInferredPredicates);
        RelOptPredicateList.append(b, "right", this.rightInferredPredicates);
        RelOptPredicateList.append(b, "constants", this.constantMap.entrySet());
        return b.append("}").toString();
    }

    private static void append(StringBuilder b, String key, Collection<?> value) {
        if (!value.isEmpty()) {
            if (b.length() > 1) {
                b.append(", ");
            }
            b.append(key);
            b.append(value);
        }
    }

    public RelOptPredicateList union(RexBuilder rexBuilder, RelOptPredicateList list) {
        if (this == EMPTY) {
            return list;
        }
        if (list == EMPTY) {
            return this;
        }
        return RelOptPredicateList.of(rexBuilder, RelOptPredicateList.concat(this.pulledUpPredicates, list.pulledUpPredicates), RelOptPredicateList.concat(this.leftInferredPredicates, list.leftInferredPredicates), RelOptPredicateList.concat(this.rightInferredPredicates, list.rightInferredPredicates));
    }

    private static <E> ImmutableList<E> concat(ImmutableList<E> list1, ImmutableList<E> list2) {
        if (list1.isEmpty()) {
            return list2;
        }
        if (list2.isEmpty()) {
            return list1;
        }
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(list1)).addAll(list2)).build();
    }

    public RelOptPredicateList shift(RexBuilder rexBuilder, int offset) {
        return RelOptPredicateList.of(rexBuilder, RexUtil.shift(this.pulledUpPredicates, offset), RexUtil.shift(this.leftInferredPredicates, offset), RexUtil.shift(this.rightInferredPredicates, offset));
    }

    public boolean isEffectivelyNotNull(RexNode e) {
        RexCall call;
        if (!e.getType().isNullable()) {
            return true;
        }
        for (RexNode p : this.pulledUpPredicates) {
            if (p.getKind() != SqlKind.IS_NOT_NULL || !((RexCall)p).getOperands().get(0).equals(e)) continue;
            return true;
        }
        if (SqlKind.COMPARISON.contains((Object)e.getKind()) && (call = (RexCall)e).getOperands().get(1) instanceof RexLiteral && !((RexLiteral)call.getOperands().get(1)).isNull()) {
            return this.isEffectivelyNotNull(call.getOperands().get(0));
        }
        return false;
    }
}

