/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.rel.hint;

import com.hazelcast.shaded.com.google.common.collect.ImmutableSet;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.shaded.org.apache.calcite.rel.convert.ConverterRule;
import com.hazelcast.shaded.org.apache.calcite.rel.hint.HintOptionChecker;
import com.hazelcast.shaded.org.apache.calcite.rel.hint.HintPredicate;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.Objects;

public class HintStrategy {
    public final HintPredicate predicate;
    public final @Nullable HintOptionChecker hintOptionChecker;
    public final ImmutableSet<RelOptRule> excludedRules;
    public final ImmutableSet<ConverterRule> converterRules;

    private HintStrategy(HintPredicate predicate, @Nullable HintOptionChecker hintOptionChecker, ImmutableSet<RelOptRule> excludedRules, ImmutableSet<ConverterRule> converterRules) {
        this.predicate = predicate;
        this.hintOptionChecker = hintOptionChecker;
        this.excludedRules = excludedRules;
        this.converterRules = converterRules;
    }

    public static Builder builder(HintPredicate hintPredicate) {
        return new Builder(hintPredicate);
    }

    public static class Builder {
        private final HintPredicate predicate;
        private @Nullable HintOptionChecker optionChecker;
        private ImmutableSet<RelOptRule> excludedRules;
        private ImmutableSet<ConverterRule> converterRules;

        private Builder(HintPredicate predicate) {
            this.predicate = Objects.requireNonNull(predicate, "predicate");
            this.excludedRules = ImmutableSet.of();
            this.converterRules = ImmutableSet.of();
        }

        public Builder optionChecker(HintOptionChecker optionChecker) {
            this.optionChecker = Objects.requireNonNull(optionChecker, "optionChecker");
            return this;
        }

        public Builder excludedRules(RelOptRule ... rules) {
            this.excludedRules = ImmutableSet.copyOf(rules);
            return this;
        }

        public Builder converterRules(ConverterRule ... rules) {
            this.converterRules = ImmutableSet.copyOf(rules);
            return this;
        }

        public HintStrategy build() {
            return new HintStrategy(this.predicate, this.optionChecker, this.excludedRules, this.converterRules);
        }
    }
}

