/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.ddl;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDrop;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import java.util.List;

public class SqlDropSchema
extends SqlDrop {
    private final boolean foreign;
    public final SqlIdentifier name;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("DROP SCHEMA", SqlKind.DROP_SCHEMA);

    SqlDropSchema(SqlParserPos pos, boolean foreign, boolean ifExists, SqlIdentifier name) {
        super(OPERATOR, pos, ifExists);
        this.foreign = foreign;
        this.name = name;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableList.of(SqlLiteral.createBoolean(this.foreign, SqlParserPos.ZERO), this.name);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DROP");
        if (this.foreign) {
            writer.keyword("FOREIGN");
        }
        writer.keyword("SCHEMA");
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
    }
}

