/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.dialect;

import com.hazelcast.shaded.org.apache.calcite.avatica.util.Casing;
import com.hazelcast.shaded.org.apache.calcite.avatica.util.TimeUnitRange;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeSystem;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlAlienSystemTypeNameSpec;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDataTypeSpec;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.fun.SqlFloorFunction;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;

public class PostgresqlSqlDialect
extends SqlDialect {
    public static final RelDataTypeSystem POSTGRESQL_TYPE_SYSTEM = new RelDataTypeSystemImpl(){

        @Override
        public int getMaxPrecision(SqlTypeName typeName) {
            switch (typeName) {
                case VARCHAR: {
                    return 0xA00000;
                }
            }
            return super.getMaxPrecision(typeName);
        }
    };
    public static final SqlDialect.Context DEFAULT_CONTEXT = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.POSTGRESQL).withIdentifierQuoteString("\"").withUnquotedCasing(Casing.TO_LOWER).withDataTypeSystem(POSTGRESQL_TYPE_SYSTEM);
    public static final SqlDialect DEFAULT = new PostgresqlSqlDialect(DEFAULT_CONTEXT);

    public PostgresqlSqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public boolean supportsCharSet() {
        return false;
    }

    @Override
    public @Nullable SqlNode getCastSpec(RelDataType type) {
        String castSpec;
        switch (type.getSqlTypeName()) {
            case TINYINT: {
                castSpec = "smallint";
                break;
            }
            case DOUBLE: {
                castSpec = "double precision";
                break;
            }
            default: {
                return super.getCastSpec(type);
            }
        }
        return new SqlDataTypeSpec(new SqlAlienSystemTypeNameSpec(castSpec, type.getSqlTypeName(), SqlParserPos.ZERO), SqlParserPos.ZERO);
    }

    @Override
    public boolean supportsFunction(SqlOperator operator, RelDataType type, List<RelDataType> paramTypes) {
        switch (operator.kind) {
            case LIKE: {
                return true;
            }
        }
        return super.supportsFunction(operator, type, paramTypes);
    }

    @Override
    public boolean requiresAliasForFromItems() {
        return true;
    }

    @Override
    public boolean supportsNestedAggregations() {
        return false;
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        switch (call.getKind()) {
            case FLOOR: {
                if (call.operandCount() != 2) {
                    super.unparseCall(writer, call, leftPrec, rightPrec);
                    return;
                }
                SqlLiteral timeUnitNode = (SqlLiteral)call.operand(1);
                TimeUnitRange timeUnit = timeUnitNode.getValueAs(TimeUnitRange.class);
                SqlCall call2 = SqlFloorFunction.replaceTimeUnitOperand(call, timeUnit.name(), timeUnitNode.getParserPosition());
                SqlFloorFunction.unparseDatetimeFunction(writer, call2, "DATE_TRUNC", false);
                break;
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }

    @Override
    public boolean supportsGroupByLiteral() {
        return false;
    }
}

