/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.validate;

import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJoin;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.AbstractNamespace;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorImpl;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;

class JoinNamespace
extends AbstractNamespace {
    private final SqlJoin join;

    JoinNamespace(SqlValidatorImpl validator, SqlJoin join) {
        super(validator, null);
        this.join = join;
    }

    @Override
    protected RelDataType validateImpl(RelDataType targetRowType) {
        RelDataType leftType = this.validator.getNamespaceOrThrow(this.join.getLeft()).getRowType();
        RelDataType rightType = this.validator.getNamespaceOrThrow(this.join.getRight()).getRowType();
        RelDataTypeFactory typeFactory = this.validator.getTypeFactory();
        switch (this.join.getJoinType()) {
            case LEFT: {
                rightType = typeFactory.createTypeWithNullability(rightType, true);
                break;
            }
            case RIGHT: {
                leftType = typeFactory.createTypeWithNullability(leftType, true);
                break;
            }
            case FULL: {
                leftType = typeFactory.createTypeWithNullability(leftType, true);
                rightType = typeFactory.createTypeWithNullability(rightType, true);
                break;
            }
        }
        return typeFactory.createJoinType(leftType, rightType);
    }

    @Override
    public @Nullable SqlNode getNode() {
        return this.join;
    }
}

