/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.util;

import com.hazelcast.shaded.com.google.common.cache.CacheBuilder;
import com.hazelcast.shaded.com.google.common.cache.CacheLoader;
import com.hazelcast.shaded.com.google.common.cache.LoadingCache;
import com.hazelcast.shaded.org.apache.calcite.avatica.util.ByteString;
import com.hazelcast.shaded.org.apache.calcite.runtime.SqlFunctions;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCollation;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.dialect.AnsiSqlDialect;
import com.hazelcast.shaded.org.apache.calcite.util.Pair;
import com.hazelcast.shaded.org.apache.calcite.util.Static;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import com.hazelcast.shaded.org.checkerframework.dataflow.qual.Pure;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class NlsString
implements Comparable<NlsString>,
Cloneable {
    private static final LoadingCache<Pair<ByteString, Charset>, String> DECODE_MAP = CacheBuilder.newBuilder().softValues().build(new CacheLoader<Pair<ByteString, Charset>, String>(){

        @Override
        public String load(Pair<ByteString, Charset> key) {
            Charset charset = (Charset)key.right;
            CharsetDecoder decoder = charset.newDecoder();
            byte[] bytes = ((ByteString)key.left).getBytes();
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            try {
                return decoder.decode(buffer).toString();
            }
            catch (CharacterCodingException ex) {
                throw Static.RESOURCE.charsetEncoding(new String(bytes, Charset.defaultCharset()), charset.name()).ex();
            }
        }
    });
    private final @Nullable String stringValue;
    private final @Nullable ByteString bytesValue;
    private final @Nullable String charsetName;
    private final @Nullable Charset charset;
    private final @Nullable SqlCollation collation;

    public NlsString(ByteString bytesValue, String charsetName, @Nullable SqlCollation collation) {
        this(null, Objects.requireNonNull(bytesValue, "bytesValue"), Objects.requireNonNull(charsetName, "charsetName"), collation);
    }

    public NlsString(String stringValue, @Nullable String charsetName, @Nullable SqlCollation collation) {
        this(Objects.requireNonNull(stringValue, "stringValue"), null, charsetName, collation);
    }

    private NlsString(@Nullable String stringValue, @Nullable ByteString bytesValue, @Nullable String charsetName, @Nullable SqlCollation collation) {
        if (charsetName != null) {
            this.charsetName = charsetName.toUpperCase(Locale.ROOT);
            this.charset = SqlUtil.getCharset(charsetName);
        } else {
            this.charsetName = null;
            this.charset = null;
        }
        if (stringValue != null == (bytesValue != null)) {
            throw new IllegalArgumentException("Specify stringValue or bytesValue");
        }
        if (bytesValue != null) {
            if (this.charset == null) {
                throw new IllegalArgumentException("Bytes value requires charset");
            }
            SqlUtil.validateCharset(bytesValue, this.charset);
        } else {
            assert (stringValue != null) : "stringValue must not be null";
            if (this.charsetName != null && (this.charsetName.equals("LATIN1") || this.charsetName.equals("ISO-8859-1"))) {
                assert (this.charset != null) : "charset must not be null";
                if (!this.charset.newEncoder().canEncode(stringValue)) {
                    throw Static.RESOURCE.charsetEncoding(stringValue, this.charset.name()).ex();
                }
            }
        }
        this.collation = collation;
        this.stringValue = stringValue;
        this.bytesValue = bytesValue;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public int hashCode() {
        return Objects.hash(this.stringValue, this.bytesValue, this.charsetName, this.collation);
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof NlsString && Objects.equals(this.stringValue, ((NlsString)obj).stringValue) && Objects.equals(this.bytesValue, ((NlsString)obj).bytesValue) && Objects.equals(this.charsetName, ((NlsString)obj).charsetName) && Objects.equals(this.collation, ((NlsString)obj).collation);
    }

    @Override
    public int compareTo(NlsString other) {
        if (this.collation != null && this.collation.getCollator() != null) {
            return this.collation.getCollator().compare(this.getValue(), other.getValue());
        }
        return this.getValue().compareTo(other.getValue());
    }

    @Pure
    public @Nullable String getCharsetName() {
        return this.charsetName;
    }

    @Pure
    public @Nullable Charset getCharset() {
        return this.charset;
    }

    @Pure
    public @Nullable SqlCollation getCollation() {
        return this.collation;
    }

    public String getValue() {
        if (this.stringValue == null) {
            assert (this.bytesValue != null) : "bytesValue must not be null";
            assert (this.charset != null) : "charset must not be null";
            return DECODE_MAP.getUnchecked(Pair.of(this.bytesValue, this.charset));
        }
        return this.stringValue;
    }

    public NlsString rtrim() {
        String trimmed = SqlFunctions.rtrim(this.getValue());
        if (!trimmed.equals(this.getValue())) {
            return new NlsString(trimmed, this.charsetName, this.collation);
        }
        return this;
    }

    public String asSql(boolean prefix, boolean suffix) {
        return this.asSql(prefix, suffix, AnsiSqlDialect.DEFAULT);
    }

    public String asSql(boolean prefix, boolean suffix, SqlDialect dialect) {
        StringBuilder ret = new StringBuilder();
        dialect.quoteStringLiteral(ret, prefix ? this.charsetName : null, this.getValue());
        return ret.toString();
    }

    public String toString() {
        return this.asSql(true, true);
    }

    public static NlsString concat(List<NlsString> args) {
        if (args.size() < 2) {
            return args.get(0);
        }
        String charSetName = args.get((int)0).charsetName;
        SqlCollation collation = args.get((int)0).collation;
        int length = args.get(0).getValue().length();
        for (int i = 1; i < args.size(); ++i) {
            NlsString arg = args.get(i);
            length += arg.getValue().length();
            if (arg.charsetName != null && !arg.charsetName.equals(charSetName)) {
                throw new IllegalArgumentException("mismatched charsets");
            }
            if (arg.collation == null || arg.collation.equals(collation)) continue;
            throw new IllegalArgumentException("mismatched collations");
        }
        StringBuilder sb = new StringBuilder(length);
        for (NlsString arg : args) {
            sb.append(arg.getValue());
        }
        return new NlsString(sb.toString(), charSetName, collation);
    }

    public NlsString copy(String value) {
        return new NlsString(value, this.charsetName, this.collation);
    }

    @Pure
    public @Nullable ByteString getValueBytes() {
        return this.bytesValue;
    }
}

