/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.buffer.validate;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryCollection;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineSegment;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineString;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.operation.buffer.validate.PointPairDistance;

public class DistanceToPointFinder {
    public static void computeDistance(Geometry geom, Coordinate pt, PointPairDistance ptDist) {
        if (geom instanceof LineString) {
            DistanceToPointFinder.computeDistance((LineString)geom, pt, ptDist);
        } else if (geom instanceof Polygon) {
            DistanceToPointFinder.computeDistance((Polygon)geom, pt, ptDist);
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)geom;
            for (int i = 0; i < gc.getNumGeometries(); ++i) {
                Geometry g2 = gc.getGeometryN(i);
                DistanceToPointFinder.computeDistance(g2, pt, ptDist);
            }
        } else {
            ptDist.setMinimum(geom.getCoordinate(), pt);
        }
    }

    public static void computeDistance(LineString line, Coordinate pt, PointPairDistance ptDist) {
        Coordinate[] coords = line.getCoordinates();
        LineSegment tempSegment = new LineSegment();
        for (int i = 0; i < coords.length - 1; ++i) {
            tempSegment.setCoordinates(coords[i], coords[i + 1]);
            Coordinate closestPt = tempSegment.closestPoint(pt);
            ptDist.setMinimum(closestPt, pt);
        }
    }

    public static void computeDistance(LineSegment segment, Coordinate pt, PointPairDistance ptDist) {
        Coordinate closestPt = segment.closestPoint(pt);
        ptDist.setMinimum(closestPt, pt);
    }

    public static void computeDistance(Polygon poly, Coordinate pt, PointPairDistance ptDist) {
        DistanceToPointFinder.computeDistance(poly.getExteriorRing(), pt, ptDist);
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            DistanceToPointFinder.computeDistance(poly.getInteriorRingN(i), pt, ptDist);
        }
    }
}

