/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.shape;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Envelope;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineSegment;

public abstract class GeometricShapeBuilder {
    protected Envelope extent = new Envelope(0.0, 1.0, 0.0, 1.0);
    protected int numPts = 0;
    protected GeometryFactory geomFactory;

    public GeometricShapeBuilder(GeometryFactory geomFactory) {
        this.geomFactory = geomFactory;
    }

    public void setExtent(Envelope extent) {
        this.extent = extent;
    }

    public Envelope getExtent() {
        return this.extent;
    }

    public Coordinate getCentre() {
        return this.extent.centre();
    }

    public double getDiameter() {
        return Math.min(this.extent.getHeight(), this.extent.getWidth());
    }

    public double getRadius() {
        return this.getDiameter() / 2.0;
    }

    public LineSegment getSquareBaseLine() {
        double radius = this.getRadius();
        Coordinate centre = this.getCentre();
        Coordinate p0 = new Coordinate(centre.x - radius, centre.y - radius);
        Coordinate p1 = new Coordinate(centre.x + radius, centre.y - radius);
        return new LineSegment(p0, p1);
    }

    public Envelope getSquareExtent() {
        double radius = this.getRadius();
        Coordinate centre = this.getCentre();
        return new Envelope(centre.x - radius, centre.x + radius, centre.y - radius, centre.y + radius);
    }

    public void setNumPoints(int numPts) {
        this.numPts = numPts;
    }

    public abstract Geometry getGeometry();

    protected Coordinate createCoord(double x, double y) {
        Coordinate pt = new Coordinate(x, y);
        this.geomFactory.getPrecisionModel().makePrecise(pt);
        return pt;
    }
}

