/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.dataconnection.DataConnection;
import com.hazelcast.dataconnection.impl.DataConnectionServiceImpl;
import com.hazelcast.map.IMap;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.schema.dataconnection.DataConnectionCatalogEntry;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class DataConnectionConsistencyChecker {
    private final HazelcastInstance hazelcastInstance;
    private final DataConnectionServiceImpl dataConnectionService;
    private IMap<Object, Object> sqlCatalog;
    private boolean initialized;

    public DataConnectionConsistencyChecker(HazelcastInstance instance, NodeEngine nodeEngine) {
        this.hazelcastInstance = instance;
        this.dataConnectionService = (DataConnectionServiceImpl)nodeEngine.getDataConnectionService();
    }

    public void init() {
        this.sqlCatalog = this.hazelcastInstance.getMap("__sql.catalog");
        this.initialized = true;
    }

    public void check() {
        if (!this.initialized) {
            return;
        }
        List sqlDataConnections = this.dataConnectionService.getSqlCreatedDataConnections();
        for (Object catalogItem : this.sqlCatalog.values()) {
            if (!(catalogItem instanceof DataConnectionCatalogEntry)) continue;
            DataConnectionCatalogEntry dl = (DataConnectionCatalogEntry)catalogItem;
            if (this.dataConnectionService.existsConfigDataConnection(dl.name())) {
                this.sqlCatalog.remove((Object)QueryUtils.wrapDataConnectionKey(dl.name()));
                continue;
            }
            this.dataConnectionService.createOrReplaceSqlDataConnection(dl.name(), dl.type(), dl.isShared(), dl.options());
        }
        for (DataConnection dataConnection : sqlDataConnections) {
            Object catalogValue = this.sqlCatalog.get((Object)QueryUtils.wrapDataConnectionKey(dataConnection.getName()));
            if (catalogValue != null) continue;
            this.dataConnectionService.removeDataConnection(dataConnection.getName());
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

