/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.expression.Expression;
import java.io.IOException;
import java.util.Objects;

public abstract class TriExpression<T>
implements Expression<T> {
    protected Expression<?> operand1;
    protected Expression<?> operand2;
    protected Expression<?> operand3;

    protected TriExpression() {
    }

    protected TriExpression(Expression<?> operand1, Expression<?> operand2, Expression<?> operand3) {
        this.operand1 = operand1;
        this.operand2 = operand2;
        this.operand3 = operand3;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.operand1);
        out.writeObject(this.operand2);
        out.writeObject(this.operand3);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.operand1 = (Expression)in.readObject();
        this.operand2 = (Expression)in.readObject();
        this.operand3 = (Expression)in.readObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriExpression that = (TriExpression)o;
        return Objects.equals(this.operand1, that.operand1) && Objects.equals(this.operand2, that.operand2) && Objects.equals(this.operand3, that.operand3);
    }

    public int hashCode() {
        int result = this.operand1 != null ? this.operand1.hashCode() : 0;
        result = 31 * result + (this.operand2 != null ? this.operand2.hashCode() : 0);
        result = 31 * result + (this.operand3 != null ? this.operand3.hashCode() : 0);
        return result;
    }

    @Override
    public boolean isCooperative() {
        return this.operand1 == null || this.operand1.isCooperative() && this.operand2 == null || this.operand2.isCooperative() && this.operand3 == null || this.operand3.isCooperative();
    }
}

