/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.math;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.BiExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;

public class DoubleBiFunction
extends BiExpression<Double> {
    public static final int POWER = 0;
    public static final int ATAN2 = 1;
    private int type;

    public DoubleBiFunction() {
    }

    public DoubleBiFunction(Expression<?> operand1, Expression<?> operand2, int type) {
        super(operand1, operand2);
        this.type = type;
    }

    public static DoubleBiFunction create(Expression<?> operand1, Expression<?> operand2, int type) {
        return new DoubleBiFunction(operand1, operand2, type);
    }

    public int getClassId() {
        return 72;
    }

    @Override
    public QueryDataType getType() {
        return QueryDataType.DOUBLE;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeInt(this.type);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.type = in.readInt();
    }

    @Override
    public Double eval(Row row, ExpressionEvalContext context) {
        Object lhsValue = this.operand1.eval(row, context);
        if (lhsValue == null) {
            return null;
        }
        Object rhsValue = this.operand2.eval(row, context);
        if (rhsValue == null) {
            return null;
        }
        assert (lhsValue instanceof Number);
        assert (rhsValue instanceof Number);
        double lhsDouble = ((Number)lhsValue).doubleValue();
        double rhsDouble = ((Number)rhsValue).doubleValue();
        switch (this.type) {
            case 0: {
                return Math.pow(lhsDouble, rhsDouble);
            }
            case 1: {
                return Math.atan2(lhsDouble, rhsDouble);
            }
        }
        throw QueryException.error((String)("Unsupported function type: " + this.type));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DoubleBiFunction)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DoubleBiFunction that = (DoubleBiFunction)o;
        return this.type == that.type;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.type;
        return result;
    }

    @Override
    public String toString() {
        return "DoubleBiFunction{ operand1=" + this.operand1 + ", operand2=" + this.operand2 + ", type=" + this.type + '}';
    }
}

