/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.math;

import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.UniExpressionWithType;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.converter.Converter;
import java.math.BigDecimal;

public class SignFunction<T>
extends UniExpressionWithType<T> {
    private static final BigDecimal DECIMAL_NEGATIVE = BigDecimal.ONE.negate();

    public SignFunction() {
    }

    private SignFunction(Expression<?> operand, QueryDataType resultType) {
        super(operand, resultType);
    }

    public static SignFunction<?> create(Expression<?> operand, QueryDataType returnType) {
        return new SignFunction(operand, returnType);
    }

    @Override
    public T eval(Row row, ExpressionEvalContext context) {
        Object operandValue = this.operand.eval(row, context);
        if (operandValue == null) {
            return null;
        }
        return (T)SignFunction.doSign(operandValue, this.operand.getType(), this.resultType);
    }

    private static Number doSign(Object operandValue, QueryDataType operandType, QueryDataType resultType) {
        Converter operandConverter = operandType.getConverter();
        switch (resultType.getTypeFamily()) {
            case TINYINT: {
                return (byte)Integer.signum(operandConverter.asInt(operandValue));
            }
            case SMALLINT: {
                return (short)Integer.signum(operandConverter.asInt(operandValue));
            }
            case INTEGER: {
                return Integer.signum(operandConverter.asInt(operandValue));
            }
            case BIGINT: {
                return (long)Long.signum(operandConverter.asBigint(operandValue));
            }
            case DECIMAL: {
                int res = operandConverter.asDecimal(operandValue).signum();
                return res == 0 ? BigDecimal.ZERO : (res == 1 ? BigDecimal.ONE : DECIMAL_NEGATIVE);
            }
            case REAL: {
                return Float.valueOf(Math.signum(operandConverter.asReal(operandValue)));
            }
            case DOUBLE: {
                return Math.signum(operandConverter.asDouble(operandValue));
            }
        }
        throw QueryException.error((String)("Unexpected type: " + resultType));
    }

    public int getClassId() {
        return 52;
    }
}

