/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector;

import com.hazelcast.jet.JetException;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.map.IMapSqlConnector;
import com.hazelcast.jet.sql.impl.schema.JetTable;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SqlConnectorUtil {
    private SqlConnectorUtil() {
    }

    public static <T extends SqlConnector> T getJetSqlConnector(Table table) {
        SqlConnector connector;
        if (table instanceof JetTable) {
            connector = ((JetTable)table).getSqlConnector();
        } else if (table instanceof PartitionedMapTable) {
            connector = IMapSqlConnector.INSTANCE;
        } else {
            throw new JetException("Unknown table type: " + table.getClass());
        }
        return (T)connector;
    }

    public static int asInt(@Nonnull Map<String, String> options, @Nonnull String propertyName, @Nullable Integer defaultValue) {
        String value = options.get(propertyName);
        if (value == null) {
            if (defaultValue == null) {
                throw QueryException.error((String)("Missing property: " + propertyName));
            }
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw QueryException.error((String)("Cannot parse option '" + propertyName + "' as integer: '" + value + '\''));
        }
    }
}

