/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.generator;

import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.jet.sql.impl.connector.generator.StreamSqlConnector;
import com.hazelcast.jet.sql.impl.connector.generator.StreamTable;
import com.hazelcast.jet.sql.impl.schema.HazelcastSpecificTableFunction;
import com.hazelcast.jet.sql.impl.schema.HazelcastSqlOperandMetadata;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.jet.sql.impl.schema.HazelcastTableFunctionParameter;
import com.hazelcast.jet.sql.impl.schema.HazelcastTableStatistic;
import com.hazelcast.jet.sql.impl.validate.HazelcastCallBinding;
import com.hazelcast.jet.sql.impl.validate.operand.TypedOperandChecker;
import com.hazelcast.jet.sql.impl.validate.operators.typeinference.HazelcastOperandTypeInference;
import com.hazelcast.jet.sql.impl.validate.operators.typeinference.ReplaceUnknownOperandTypeInference;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.expression.Expression;
import java.util.Collections;
import java.util.List;

public final class StreamGeneratorTableFunction
extends HazelcastSpecificTableFunction {
    private static final String SCHEMA_NAME_STREAM = "stream";
    private static final String FUNCTION_NAME = "GENERATE_STREAM";
    private static final List<HazelcastTableFunctionParameter> PARAMETERS = Collections.singletonList(new HazelcastTableFunctionParameter(0, "rate", SqlTypeName.INTEGER, false, TypedOperandChecker.INTEGER));

    public StreamGeneratorTableFunction() {
        super(FUNCTION_NAME, StreamOperandMetadata.INSTANCE, binding -> StreamGeneratorTableFunction.toTable0(Collections.emptyList()).getRowType(binding.getTypeFactory()));
    }

    @Override
    public HazelcastTable toTable(List<Expression<?>> argumentExpressions) {
        return StreamGeneratorTableFunction.toTable0(argumentExpressions);
    }

    private static HazelcastTable toTable0(List<Expression<?>> argumentExpressions) {
        StreamTable table = StreamSqlConnector.createTable(SCHEMA_NAME_STREAM, StreamGeneratorTableFunction.randomName(), argumentExpressions);
        return new HazelcastTable(table, new HazelcastTableStatistic(Integer.MAX_VALUE));
    }

    private static String randomName() {
        return "stream_" + UuidUtil.newUnsecureUuidString().replace('-', '_');
    }

    private static final class StreamOperandMetadata
    extends HazelcastSqlOperandMetadata {
        private static final StreamOperandMetadata INSTANCE = new StreamOperandMetadata();

        private StreamOperandMetadata() {
            super(PARAMETERS, new HazelcastOperandTypeInference(PARAMETERS, new ReplaceUnknownOperandTypeInference(SqlTypeName.INTEGER)));
        }

        @Override
        protected boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
            return true;
        }
    }
}

