/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.generator;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.impl.pipeline.transform.StreamSourceTransform;
import com.hazelcast.jet.sql.impl.connector.HazelcastRexNode;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.generator.StreamTable;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StreamSqlConnector
implements SqlConnector {
    static final StreamSqlConnector INSTANCE = new StreamSqlConnector();
    private static final String TYPE_NAME = "Stream";
    private static final List<TableField> FIELDS = Collections.singletonList(new TableField("v", QueryDataType.BIGINT, false));

    @Override
    public String typeName() {
        return TYPE_NAME;
    }

    @Override
    @Nonnull
    public String defaultObjectType() {
        return TYPE_NAME;
    }

    @Override
    @Nonnull
    public List<MappingField> resolveAndValidateFields(@Nonnull NodeEngine nodeEngine, @Nonnull SqlConnector.SqlExternalResource externalResource, @Nonnull List<MappingField> userFields) {
        throw new UnsupportedOperationException("Resolving fields not supported for " + this.typeName());
    }

    @Override
    @Nonnull
    public Table createTable(@Nonnull NodeEngine nodeEngine, @Nonnull String schemaName, @Nonnull String mappingName, @Nonnull SqlConnector.SqlExternalResource externalResource, @Nonnull List<MappingField> resolvedFields) {
        throw new UnsupportedOperationException("Creating table not supported for " + this.typeName());
    }

    @Nonnull
    public static StreamTable createTable(String schemaName, String name, List<Expression<?>> argumentExpressions) {
        return new StreamTable(INSTANCE, FIELDS, schemaName, name, argumentExpressions);
    }

    @Override
    @Nonnull
    public Vertex fullScanReader(@Nonnull SqlConnector.DagBuildContext context, @Nullable HazelcastRexNode predicate, @Nonnull List<HazelcastRexNode> projection, @Nullable FunctionEx<ExpressionEvalContext, EventTimePolicy<JetSqlRow>> eventTimePolicyProvider) {
        StreamTable table = (StreamTable)context.getTable();
        StreamSourceTransform source = (StreamSourceTransform)table.items(context.convertFilter(predicate), context.convertProjection(projection));
        ProcessorMetaSupplier pms = (ProcessorMetaSupplier)source.metaSupplierFn.apply((Object)EventTimePolicy.noEventTime());
        Vertex vertex = context.getDag().newUniqueVertex(table.toString(), pms);
        if (eventTimePolicyProvider != null) {
            Vertex addWm = context.getDag().newUniqueVertex("addWm", Processors.insertWatermarksP((FunctionEx & Serializable)ctx -> (EventTimePolicy)eventTimePolicyProvider.apply((Object)ExpressionEvalContext.from(ctx))));
            context.getDag().edge(Edge.between((Vertex)vertex, (Vertex)addWm).isolated());
            vertex = addWm;
        }
        return vertex;
    }

    @Override
    public boolean supportsExpression(@Nonnull HazelcastRexNode expression) {
        return true;
    }
}

