/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.jet.sql.impl.connector.jdbc.AbstractQueryBuilder;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTable;
import com.hazelcast.shaded.com.google.common.primitives.Ints;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class SelectQueryBuilder
extends AbstractQueryBuilder {
    private final List<Integer> dynamicParams = new ArrayList<Integer>();

    SelectQueryBuilder(JdbcTable table, SqlDialect dialect, RexNode predicate, List<RexNode> projection) {
        super(table, dialect);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        if (!projection.isEmpty()) {
            this.appendProjection(sb, projection);
        } else {
            sb.append("*");
        }
        sb.append(" FROM ");
        dialect.quoteIdentifier(sb, table.getExternalNameList());
        if (predicate != null) {
            this.appendPredicate(sb, predicate, this.dynamicParams);
        }
        this.query = sb.toString();
    }

    private void appendProjection(StringBuilder sb, List<RexNode> projection) {
        Iterator<RexNode> it = projection.iterator();
        while (it.hasNext()) {
            RexNode node = it.next();
            sb.append(this.context.toSql(null, node).toSqlString(this.dialect).toString());
            if (!it.hasNext()) continue;
            sb.append(',');
        }
    }

    int[] parameterPositions() {
        return Ints.toArray(this.dynamicParams);
    }
}

