/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc.h2;

import com.hazelcast.jet.sql.impl.connector.jdbc.AbstractQueryBuilder;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTable;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;

public class H2UpsertQueryBuilder
extends AbstractQueryBuilder {
    public H2UpsertQueryBuilder(JdbcTable jdbcTable, SqlDialect dialect) {
        super(jdbcTable, dialect);
        StringBuilder sb = new StringBuilder();
        this.appendMergeClause(sb);
        sb.append(' ');
        this.appendKeyClause(sb);
        sb.append(' ');
        this.appendValuesClause(sb);
        this.query = sb.toString();
    }

    void appendMergeClause(StringBuilder sb) {
        sb.append("MERGE INTO ");
        this.dialect.quoteIdentifier(sb, this.jdbcTable.getExternalNameList());
        sb.append(' ');
        this.appendFieldNames(sb, this.jdbcTable.dbFieldNames());
    }

    void appendKeyClause(StringBuilder sb) {
        sb.append("KEY ");
        this.appendFieldNames(sb, this.jdbcTable.getPrimaryKeyList());
    }

    void appendValuesClause(StringBuilder sb) {
        sb.append("VALUES ");
        this.appendValues(sb, this.jdbcTable.dbFieldNames().size());
    }
}

