/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.mongodb;

import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonJavaScript;
import org.bson.BsonJavaScriptWithScope;
import org.bson.BsonMaxKey;
import org.bson.BsonMinKey;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonType;
import org.bson.Document;
import org.bson.types.Decimal128;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;

public final class ConversionsToBson {
    private static final int HEX_RADIX = 16;

    private ConversionsToBson() {
    }

    public static Object convertToBson(Object value, QueryDataType sqlType, BsonType bsonType) {
        if (value == null) {
            return null;
        }
        Object converted = null;
        switch (bsonType) {
            case OBJECT_ID: {
                converted = ConversionsToBson.convertToObjectId(value);
                break;
            }
            case ARRAY: {
                converted = ConversionsToBson.convertToArray(value);
                break;
            }
            case BOOLEAN: {
                converted = ConversionsToBson.convertToBoolean(value);
                break;
            }
            case DATE_TIME: {
                converted = ConversionsToBson.convertToDateTime(value);
                break;
            }
            case TIMESTAMP: {
                converted = ConversionsToBson.convertToTimestamp(value);
                break;
            }
            case INT32: {
                converted = ConversionsToBson.convertToInt(value);
                break;
            }
            case INT64: {
                converted = ConversionsToBson.convertToLong(value);
                break;
            }
            case DOUBLE: {
                converted = ConversionsToBson.convertToDouble(value);
                break;
            }
            case DECIMAL128: {
                converted = ConversionsToBson.convertToBigDecimal(value);
                break;
            }
            case DOCUMENT: {
                converted = ConversionsToBson.convertToDocument(value);
                break;
            }
            case JAVASCRIPT: {
                converted = ConversionsToBson.convertToJavaScript(value);
                break;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                converted = ConversionsToBson.convertToJavaScriptWithScope(value);
                break;
            }
            case STRING: {
                converted = ConversionsToBson.convertToString(value);
                break;
            }
            case REGULAR_EXPRESSION: {
                converted = ConversionsToBson.convertToRegEx(value);
                break;
            }
            case MIN_KEY: {
                converted = ConversionsToBson.convertToMinKey(value);
                break;
            }
            case MAX_KEY: {
                converted = ConversionsToBson.convertToMaxKey(value);
                break;
            }
        }
        if (converted == null) {
            return sqlType.convert(value);
        }
        return converted;
    }

    private static Object convertToDateTime(Object value) {
        if (value instanceof BsonDateTime) {
            return value;
        }
        if (value instanceof Integer) {
            return LocalDateTime.ofEpochSecond(((Integer)value).intValue(), 0, ZoneOffset.UTC);
        }
        if (value instanceof Long) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli((Long)value), ZoneOffset.UTC);
        }
        if (value instanceof CharSequence) {
            return LocalDateTime.parse((CharSequence)value);
        }
        if (value instanceof BsonString) {
            return LocalDateTime.parse(((BsonString)value).getValue());
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime v = (LocalDateTime)value;
            return new BsonDateTime(v.atZone(ZoneId.systemDefault()).withZoneSameInstant(ZoneOffset.UTC).toInstant().toEpochMilli());
        }
        if (value instanceof ZonedDateTime) {
            ZonedDateTime v = (ZonedDateTime)value;
            return new BsonDateTime(v.withZoneSameInstant(ZoneOffset.UTC).toInstant().toEpochMilli());
        }
        if (value instanceof OffsetDateTime) {
            OffsetDateTime v = (OffsetDateTime)value;
            return new BsonDateTime(v.atZoneSameInstant(ZoneOffset.UTC).toInstant().toEpochMilli());
        }
        return null;
    }

    private static BsonTimestamp convertToTimestamp(Object value) {
        if (value instanceof BsonTimestamp) {
            return (BsonTimestamp)value;
        }
        if (value instanceof Number) {
            return new BsonTimestamp(((Number)value).longValue());
        }
        if (value instanceof String) {
            return new BsonTimestamp(Long.parseLong((String)value));
        }
        if (value instanceof BsonString) {
            return new BsonTimestamp(Long.parseLong(((BsonString)value).getValue()));
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime v = (LocalDateTime)value;
            return new BsonTimestamp((int)v.atZone(ZoneId.systemDefault()).withZoneSameInstant(ZoneOffset.UTC).toEpochSecond(), 0);
        }
        if (value instanceof ZonedDateTime) {
            ZonedDateTime v = (ZonedDateTime)value;
            return new BsonTimestamp((int)v.withZoneSameInstant(ZoneOffset.UTC).toEpochSecond(), 0);
        }
        if (value instanceof OffsetDateTime) {
            OffsetDateTime v = (OffsetDateTime)value;
            return new BsonTimestamp((int)v.atZoneSameInstant(ZoneOffset.UTC).toEpochSecond(), 0);
        }
        return null;
    }

    private static ObjectId convertToObjectId(Object value) {
        if (value instanceof ObjectId) {
            return (ObjectId)value;
        }
        if (value instanceof String) {
            return new ObjectId((String)value);
        }
        if (value instanceof Integer) {
            return new ObjectId(Integer.toHexString((Integer)value));
        }
        if (value instanceof Long) {
            return new ObjectId(Long.toHexString((Long)value));
        }
        if (value instanceof BigDecimal) {
            BigDecimal v = (BigDecimal)value;
            return new ObjectId(v.toBigInteger().toString(16));
        }
        if (value instanceof BigInteger) {
            BigInteger v = (BigInteger)value;
            return new ObjectId(v.toString(16));
        }
        return null;
    }

    private static Collection<?> convertToArray(Object value) {
        if (value instanceof Collection) {
            return (Collection)value;
        }
        return Collections.singletonList(value);
    }

    private static Boolean convertToBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue() > 0.0;
        }
        return null;
    }

    private static Integer convertToInt(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof BsonInt32) {
            return ((BsonInt32)value).getValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return null;
    }

    private static Long convertToLong(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof BsonInt64) {
            return ((BsonInt64)value).getValue();
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return null;
    }

    private static Double convertToDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof BsonDouble) {
            return ((BsonDouble)value).getValue();
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return null;
    }

    private static Object convertToBigDecimal(Object value) {
        if (value instanceof BigDecimal || value instanceof BsonDecimal128 || value instanceof Decimal128) {
            return value;
        }
        if (value instanceof String) {
            return new BigDecimal((String)value);
        }
        if (value instanceof Number) {
            return new BigDecimal(value.toString());
        }
        return null;
    }

    private static Document convertToDocument(Object value) {
        if (value instanceof Document) {
            return (Document)value;
        }
        if (value instanceof String) {
            return Document.parse((String)((String)value));
        }
        if (value instanceof BsonString) {
            return Document.parse((String)((BsonString)value).getValue());
        }
        if (value instanceof HazelcastJsonValue) {
            return Document.parse((String)((HazelcastJsonValue)value).getValue());
        }
        if (value instanceof Map) {
            return new Document((Map)value);
        }
        return null;
    }

    private static BsonJavaScript convertToJavaScript(Object value) {
        if (value instanceof BsonJavaScript) {
            return (BsonJavaScript)value;
        }
        if (value instanceof String) {
            return new BsonJavaScript((String)value);
        }
        return null;
    }

    private static BsonJavaScriptWithScope convertToJavaScriptWithScope(Object value) {
        if (value instanceof BsonJavaScriptWithScope) {
            return (BsonJavaScriptWithScope)value;
        }
        if (value instanceof Document) {
            Document doc = (Document)value;
            return new BsonJavaScriptWithScope(doc.getString((Object)"code"), (BsonDocument)doc.get((Object)"scope"));
        }
        if (value instanceof BsonDocument) {
            BsonDocument doc = (BsonDocument)value;
            return new BsonJavaScriptWithScope(doc.getString((Object)"code").toString(), (BsonDocument)doc.get((Object)"scope"));
        }
        return null;
    }

    private static String convertToString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof BsonString) {
            return ((BsonString)value).getValue();
        }
        if (value instanceof BsonJavaScript) {
            return ((BsonJavaScript)value).getCode();
        }
        if (value instanceof Document) {
            return ((Document)value).toJson();
        }
        if (value instanceof BsonDocument) {
            return ((BsonDocument)value).toJson();
        }
        if (value instanceof BsonJavaScriptWithScope) {
            BsonJavaScriptWithScope v = (BsonJavaScriptWithScope)value;
            Document doc = new Document();
            doc.put("code", (Object)v.getCode());
            doc.put("scope", (Object)v.getScope());
            return doc.toJson();
        }
        return value.toString();
    }

    private static BsonRegularExpression convertToRegEx(Object value) {
        if (value instanceof BsonRegularExpression) {
            return (BsonRegularExpression)value;
        }
        if (value instanceof String) {
            return new BsonRegularExpression((String)value);
        }
        return null;
    }

    private static MinKey convertToMinKey(Object value) {
        if (value instanceof MinKey) {
            return (MinKey)value;
        }
        if (value instanceof BsonMinKey) {
            return new MinKey();
        }
        if (value instanceof String && "Minkey".equalsIgnoreCase((String)value)) {
            return new MinKey();
        }
        return null;
    }

    private static MaxKey convertToMaxKey(Object value) {
        if (value instanceof MaxKey) {
            return (MaxKey)value;
        }
        if (value instanceof BsonMaxKey) {
            return new MaxKey();
        }
        if (value instanceof String && "MaxKey".equalsIgnoreCase((String)value)) {
            return new MaxKey();
        }
        return null;
    }
}

