/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.mongodb;

import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Objects;
import org.bson.BsonType;

class MongoTableField
extends TableField {
    final String externalName;
    final BsonType externalType;
    final boolean primaryKey;

    MongoTableField(String name, QueryDataType type, String externalName, boolean hidden, String externalType, boolean primaryKey) {
        super(name, type, hidden);
        this.externalName = externalName;
        this.externalType = externalType == null ? null : BsonType.valueOf((String)externalType);
        this.primaryKey = primaryKey;
    }

    public String getExternalName() {
        return this.externalName;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public BsonType getExternalType() {
        return this.externalType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MongoTableField)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MongoTableField that = (MongoTableField)o;
        return this.primaryKey == that.primaryKey && Objects.equals(this.externalName, that.externalName) && Objects.equals(this.externalType, that.externalType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.externalName, this.primaryKey, this.externalType);
    }
}

