/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.mongodb;

import com.hazelcast.shaded.org.apache.calcite.rex.RexCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.mongodb.client.model.Filters;
import java.util.Arrays;
import org.bson.Document;
import org.bson.conversions.Bson;

public final class RexToMongo {
    private RexToMongo() {
    }

    public static Bson convertCall(RexCall call, Object[] operands) {
        SqlOperator operator = call.getOperator();
        switch (operator.getKind()) {
            case AND: {
                return Filters.and((Bson[])RexToMongo.convertOperands(operands));
            }
            case OR: {
                return Filters.or((Bson[])RexToMongo.convertOperands(operands));
            }
            case NOT: {
                if (operands[0] instanceof String) {
                    assert (call.getOperands().get(0).getType().getSqlTypeName().equals((Object)SqlTypeName.BOOLEAN));
                    return Filters.ne((String)((String)operands[0]), (Object)true);
                }
                return Filters.not((Bson)((Bson)operands[0]));
            }
            case EQUALS: {
                assert (operands[0] instanceof String);
                return Filters.expr((Object)new Document("$eq", Arrays.asList(operands[0], operands[1])));
            }
            case NOT_EQUALS: {
                assert (operands[0] instanceof String);
                return Filters.expr((Object)new Document("$ne", Arrays.asList(operands[0], operands[1])));
            }
            case GREATER_THAN: {
                assert (operands[0] instanceof String);
                return Filters.expr((Object)new Document("$gt", Arrays.asList(operands[0], operands[1])));
            }
            case GREATER_THAN_OR_EQUAL: {
                assert (operands[0] instanceof String);
                return Filters.expr((Object)new Document("$gte", Arrays.asList(operands[0], operands[1])));
            }
            case LESS_THAN: {
                assert (operands[0] instanceof String);
                return Filters.expr((Object)new Document("$lt", Arrays.asList(operands[0], operands[1])));
            }
            case LESS_THAN_OR_EQUAL: {
                assert (operands[0] instanceof String);
                return Filters.expr((Object)new Document("$lte", Arrays.asList(operands[0], operands[1])));
            }
            case IS_TRUE: {
                return Filters.eq((String)((String)operands[0]), (Object)true);
            }
            case IS_NOT_TRUE: {
                return Filters.ne((String)((String)operands[0]), (Object)true);
            }
            case IS_FALSE: {
                return Filters.eq((String)((String)operands[0]), (Object)false);
            }
            case IS_NOT_FALSE: {
                return Filters.ne((String)((String)operands[0]), (Object)false);
            }
            case IS_NULL: {
                return Filters.or((Bson[])new Bson[]{Filters.exists((String)((String)operands[0]), (boolean)false), Filters.eq((String)((String)operands[0]), null)});
            }
            case IS_NOT_NULL: {
                return Filters.and((Bson[])new Bson[]{Filters.exists((String)((String)operands[0])), Filters.ne((String)((String)operands[0]), null)});
            }
        }
        throw new UnsupportedOperationException();
    }

    private static Bson[] convertOperands(Object[] operands) {
        Bson[] r = new Bson[operands.length];
        for (int i = 0; i < operands.length; ++i) {
            Object ith = operands[i];
            if (ith instanceof String) {
                r[i] = Filters.eq((String)((String)ith), (Object)true);
                continue;
            }
            if (ith instanceof Bson) {
                r[i] = (Bson)ith;
                continue;
            }
            throw new UnsupportedOperationException("Not supported type of operand: " + ith.getClass());
        }
        return r;
    }
}

