/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.mongodb;

import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.mongodb.MongoSinkBuilder;
import com.hazelcast.jet.mongodb.impl.Mappers;
import com.hazelcast.jet.mongodb.impl.MongoUtilities;
import com.hazelcast.jet.mongodb.impl.UpdateMongoP;
import com.hazelcast.jet.mongodb.impl.WriteMongoP;
import com.hazelcast.jet.mongodb.impl.WriteMongoParams;
import com.hazelcast.jet.sql.impl.connector.mongodb.DynamicallyReplacedPlaceholder;
import com.hazelcast.jet.sql.impl.connector.mongodb.MongoTable;
import com.hazelcast.jet.sql.impl.connector.mongodb.PlaceholderReplacer;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Field;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.WriteModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.bson.Document;
import org.bson.conversions.Bson;

public class UpdateProcessorSupplier
implements ProcessorSupplier {
    private final String connectionString;
    private final String databaseName;
    private final String collectionName;
    private final List<String> updatedFieldNames;
    private final List<? extends Serializable> updates;
    private final String dataConnectionName;
    private final String[] externalNames;
    private final boolean afterScan;
    private ExpressionEvalContext evalContext;
    private transient SupplierEx<MongoClient> clientSupplier;
    private final String pkExternalName;
    private final Serializable predicate;

    UpdateProcessorSupplier(MongoTable table, List<String> updatedFieldNames, List<? extends Serializable> updates, Serializable predicate, boolean hasInput) {
        this.connectionString = table.connectionString;
        this.dataConnectionName = table.dataConnectionName;
        this.databaseName = table.databaseName;
        this.collectionName = table.collectionName;
        this.updatedFieldNames = updatedFieldNames;
        this.updates = updates;
        this.pkExternalName = table.primaryKeyExternalName();
        this.predicate = predicate;
        this.externalNames = table.externalNames();
        this.afterScan = hasInput;
    }

    public void init(@Nonnull ProcessorSupplier.Context context) throws Exception {
        if (this.connectionString != null) {
            this.clientSupplier = (SupplierEx & Serializable)() -> MongoClients.create((String)this.connectionString);
        }
        this.evalContext = ExpressionEvalContext.from(context);
    }

    @Nonnull
    public Collection<? extends Processor> get(int count) {
        Processor[] processors = new Processor[count];
        if (!this.afterScan) {
            Document predicateWithReplacements = this.predicate == null ? MongoUtilities.UPDATE_ALL_PREDICATE : DynamicallyReplacedPlaceholder.replacePlaceholdersInPredicate(this.predicate, this.externalNames, this.evalContext);
            for (int i = 0; i < count; ++i) {
                UpdateMongoP processor = new UpdateMongoP(new WriteMongoParams().setClientSupplier(this.clientSupplier).setDataConnectionRef(this.dataConnectionName).setDatabaseName(this.databaseName).setCollectionName(this.collectionName).setDocumentType(Document.class), this.writeModelNoScan(predicateWithReplacements));
                processors[i] = processor;
            }
            return Arrays.asList(processors);
        }
        for (int i = 0; i < count; ++i) {
            WriteMongoP processor = new WriteMongoP(new WriteMongoParams().setClientSupplier(this.clientSupplier).setDataConnectionRef(this.dataConnectionName).setDatabaseName(this.databaseName).setCollectionName(this.collectionName).setDocumentType(Document.class).setCommitRetryStrategy(MongoSinkBuilder.DEFAULT_COMMIT_RETRY_STRATEGY).setTransactionOptionsSup((SupplierEx & Serializable)() -> MongoSinkBuilder.DEFAULT_TRANSACTION_OPTION).setIntermediateMappingFn(this::rowToUpdateDoc).setWriteModelFn(this::writeModelAfterScan));
            processors[i] = processor;
        }
        return Arrays.asList(processors);
    }

    private SupplierEx<WriteModel<Document>> writeModelNoScan(Document predicate) {
        return (SupplierEx & Serializable)() -> {
            Document values = this.valuesToUpdateDoc(this.externalNames);
            List pipeline = (List)values.get((Object)"update", List.class);
            UpdateManyModel doc = new UpdateManyModel((Bson)predicate, pipeline);
            return doc;
        };
    }

    private WriteModel<Document> writeModelAfterScan(Document update) {
        List updates = (List)Objects.requireNonNull(update.get((Object)"update", List.class), "updateList");
        Bson filter = (Bson)Objects.requireNonNull(update.get((Object)"filter", Bson.class));
        return new UpdateManyModel(filter, updates);
    }

    private Document rowToUpdateDoc(JetSqlRow row) {
        Object[] values = row.getValues();
        return this.valuesToUpdateDoc(values);
    }

    private Document valuesToUpdateDoc(Object[] values) {
        Object pkValue = values[0];
        ArrayList<Bson> updateToPerform = new ArrayList<Bson>();
        for (int i = 0; i < this.updatedFieldNames.size(); ++i) {
            String fieldName = this.updatedFieldNames.get(i);
            Serializable updateExpr = this.updates.get(i);
            if (updateExpr instanceof Bson) {
                Document document = Document.parse((String)((Bson)updateExpr).toBsonDocument(Document.class, Mappers.defaultCodecRegistry()).toJson());
                PlaceholderReplacer.replacePlaceholders(document, this.evalContext, values, this.externalNames, this.afterScan);
                updateExpr = document;
                updateToPerform.add(Aggregates.set((Field[])new Field[]{new Field(fieldName, (Object)updateExpr)}));
                continue;
            }
            if (updateExpr instanceof String) {
                String expr = (String)((Object)updateExpr);
                Object withReplacements = PlaceholderReplacer.replace(expr, this.evalContext, values, this.externalNames, false, this.afterScan);
                updateToPerform.add(Aggregates.set((Field[])new Field[]{new Field(fieldName, withReplacements)}));
                continue;
            }
            updateToPerform.add(Aggregates.set((Field[])new Field[]{new Field(fieldName, (Object)updateExpr)}));
        }
        Bson filter = Filters.eq((String)this.pkExternalName, (Object)pkValue);
        return new Document("filter", (Object)filter).append("update", updateToPerform);
    }
}

