/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression;

import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.sql.impl.expression.json.JsonCreationUtil;
import com.hazelcast.query.impl.getters.EvictableGetterCache;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.query.impl.getters.GetterCache;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.UniExpressionWithType;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class UdtObjectToJsonFunction
extends UniExpressionWithType<HazelcastJsonValue> {
    private static final int MAX_CLASS_COUNT = 64;
    private static final int MAX_GETTER_PER_CLASS_COUNT = 100;
    private final GetterCache getterCache = new EvictableGetterCache(64, 100, 0.2f, false);

    public UdtObjectToJsonFunction() {
    }

    private UdtObjectToJsonFunction(Expression<?> operand) {
        super(operand, QueryDataType.JSON);
    }

    public static UdtObjectToJsonFunction create(Expression<?> operand) {
        return new UdtObjectToJsonFunction(operand);
    }

    @Override
    public HazelcastJsonValue eval(Row row, ExpressionEvalContext context) {
        Object obj = this.operand.eval(row, context);
        QueryDataType queryDataType = this.operand.getType();
        if (obj == null) {
            return null;
        }
        Extractors extractors = Extractors.newBuilder((InternalSerializationService)context.getSerializationService()).setGetterCacheSupplier(() -> this.getterCache).build();
        HashMap<String, Object> value = new HashMap<String, Object>();
        this.convert(obj, value, queryDataType, Collections.newSetFromMap(new IdentityHashMap()), extractors);
        return new HazelcastJsonValue(JsonCreationUtil.serializeValue(value));
    }

    private void convert(Object source, Map<String, Object> values, QueryDataType dataType, Set<Object> seenObjects, Extractors extractors) {
        if (!seenObjects.add(source)) {
            throw QueryException.error((int)2000, (String)"Cycle detected in row value");
        }
        for (QueryDataType.QueryDataTypeField field : dataType.getObjectFields()) {
            Object fieldValue = extractors.extract(source, field.getName(), (Object)false);
            if (!field.getDataType().isCustomType() || fieldValue == null) {
                values.put(field.getName(), fieldValue);
                continue;
            }
            HashMap<String, Object> subFieldValue = new HashMap<String, Object>();
            values.put(field.getName(), subFieldValue);
            this.convert(fieldValue, subFieldValue, field.getDataType(), seenObjects, extractors);
        }
    }

    public int getClassId() {
        return 26;
    }

    @Override
    public QueryDataType getType() {
        return QueryDataType.JSON;
    }
}

