/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.inject;

import com.hazelcast.jet.sql.impl.inject.UpsertInjector;
import com.hazelcast.jet.sql.impl.inject.UpsertTarget;
import com.hazelcast.jet.sql.impl.inject.UpsertTargetUtils;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.schema.type.TypeKind;
import com.hazelcast.sql.impl.type.QueryDataType;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class HazelcastObjectUpsertTarget
implements UpsertTarget {
    private Object object;

    HazelcastObjectUpsertTarget() {
    }

    @Override
    public UpsertInjector createInjector(@Nullable String path, QueryDataType queryDataType) {
        TypeKind typeKind = TypeKind.of(queryDataType.getObjectTypeKind());
        switch (typeKind) {
            case JAVA: {
                return value -> {
                    this.object = UpsertTargetUtils.convertRowToJavaType(value, queryDataType);
                };
            }
        }
        throw QueryException.error((String)("TypeKind " + (Object)((Object)typeKind) + " does not support top-level custom types"));
    }

    @Override
    public void init() {
    }

    @Override
    public Object conclude() {
        return this.object;
    }
}

