/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.inject;

import com.hazelcast.internal.serialization.impl.portable.FieldDefinitionImpl;
import com.hazelcast.jet.datamodel.Tuple3;
import com.hazelcast.jet.impl.util.ReflectionUtils;
import com.hazelcast.jet.sql.impl.schema.TypesUtils;
import com.hazelcast.jet.sql.impl.type.converter.ToConverter;
import com.hazelcast.jet.sql.impl.type.converter.ToConverters;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.ClassDefinitionBuilder;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.genericrecord.GenericRecord;
import com.hazelcast.nio.serialization.genericrecord.GenericRecordBuilder;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.RowValue;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;

public final class UpsertTargetUtils {
    private UpsertTargetUtils() {
    }

    public static Object convertRowToJavaType(Object value, QueryDataType type) {
        Class targetClass = ReflectionUtils.loadClass((String)type.getObjectTypeMetadata());
        if (value.getClass().isAssignableFrom(targetClass)) {
            return value;
        }
        if (!(value instanceof RowValue)) {
            throw QueryException.error((String)("Can not assign value of class " + value.getClass().getName() + " to OBJECT field."));
        }
        RowValue rowValue = (RowValue)value;
        Object result = ReflectionUtils.newInstance((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)targetClass.getName());
        for (int i = 0; i < type.getObjectFields().size(); ++i) {
            QueryDataType.QueryDataTypeField typeField = type.getObjectFields().get(i);
            boolean isRowValueField = rowValue.getValues().get(i) instanceof RowValue;
            Object fieldValue = isRowValueField ? UpsertTargetUtils.convertRowToJavaType(rowValue.getValues().get(i), typeField.getDataType()) : rowValue.getValues().get(i);
            Method setter = ReflectionUtils.findPropertySetter((Class)targetClass, (String)typeField.getName());
            ToConverter toConverter = ToConverters.getToConverter(typeField.getDataType());
            if (setter != null) {
                if (fieldValue == null && setter.getParameterTypes()[0].isPrimitive()) {
                    throw QueryException.error((String)("Cannot pass NULL to a method with a primitive argument: " + setter));
                }
                try {
                    if (typeField.getDataType().getTypeFamily().equals((Object)QueryDataTypeFamily.OBJECT)) {
                        setter.invoke(result, fieldValue);
                        continue;
                    }
                    setter.invoke(result, toConverter.convert(fieldValue));
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw QueryException.error((String)("Can not use setter for field " + typeField.getName()), (Throwable)e);
                }
            }
            Field field = ReflectionUtils.findPropertyField((Class)targetClass, (String)typeField.getName());
            if (field == null) {
                throw QueryException.error((String)("Can not find field: " + typeField.getName()));
            }
            try {
                if (fieldValue == null && field.getType().isPrimitive()) {
                    throw QueryException.error((String)("Cannot set NULL to a primitive field: " + field));
                }
                if (typeField.getDataType().getTypeFamily().equals((Object)QueryDataTypeFamily.OBJECT)) {
                    field.set(result, fieldValue);
                    continue;
                }
                field.set(result, toConverter.convert(fieldValue));
                continue;
            }
            catch (IllegalAccessException e) {
                throw QueryException.error((String)("Can not set value for field " + typeField.getName()), (Throwable)e);
            }
        }
        return result;
    }

    public static GenericRecord convertRowToCompactType(RowValue rowValue, QueryDataType targetDataType) {
        GenericRecordBuilder recordBuilder = GenericRecordBuilder.compact((String)targetDataType.getObjectTypeMetadata());
        UpsertTargetUtils.setCompactFields(rowValue, targetDataType, recordBuilder);
        return recordBuilder.build();
    }

    public static GenericRecord convertRowToPortableType(RowValue rowValue, QueryDataType queryDataType) {
        ClassDefinition classDefinition = UpsertTargetUtils.toPortableClassDefinition(queryDataType);
        GenericRecordBuilder recordBuilder = GenericRecordBuilder.portable((ClassDefinition)classDefinition);
        UpsertTargetUtils.setPortableFields(recordBuilder, rowValue, classDefinition, queryDataType);
        return recordBuilder.build();
    }

    private static void setPortableFields(GenericRecordBuilder builder, RowValue rowValue, ClassDefinition classDefinition, QueryDataType queryDataType) {
        block17: for (int i = 0; i < classDefinition.getFieldCount(); ++i) {
            Object value = rowValue.getValues().get(i);
            FieldDefinition field = classDefinition.getField(i);
            String name = field.getName();
            switch (field.getType()) {
                case UTF: {
                    builder.setString(name, value == null ? null : (String)QueryDataType.VARCHAR.convert(value));
                    continue block17;
                }
                case BOOLEAN: {
                    builder.setBoolean(name, value != null && (Boolean)value != false);
                    continue block17;
                }
                case BYTE: {
                    builder.setInt8(name, value == null ? (byte)0 : (Byte)value);
                    continue block17;
                }
                case SHORT: {
                    builder.setInt16(name, value == null ? (short)0 : (Short)value);
                    continue block17;
                }
                case CHAR: {
                    builder.setChar(name, value == null ? (char)'\u0000' : ((Character)value).charValue());
                    continue block17;
                }
                case INT: {
                    builder.setInt32(name, value == null ? 0 : (Integer)value);
                    continue block17;
                }
                case LONG: {
                    builder.setInt64(name, value == null ? 0L : (Long)value);
                    continue block17;
                }
                case FLOAT: {
                    builder.setFloat32(name, value == null ? 0.0f : ((Float)value).floatValue());
                    continue block17;
                }
                case DOUBLE: {
                    builder.setFloat64(name, value == null ? 0.0 : (Double)value);
                    continue block17;
                }
                case DECIMAL: {
                    builder.setDecimal(name, value == null ? null : (BigDecimal)value);
                    continue block17;
                }
                case TIME: {
                    builder.setTime(name, value == null ? null : (LocalTime)value);
                    continue block17;
                }
                case DATE: {
                    builder.setDate(name, value == null ? null : (LocalDate)value);
                    continue block17;
                }
                case TIMESTAMP: {
                    builder.setTimestamp(name, value == null ? null : (LocalDateTime)value);
                    continue block17;
                }
                case TIMESTAMP_WITH_TIMEZONE: {
                    builder.setTimestampWithTimezone(name, value == null ? null : (OffsetDateTime)value);
                    continue block17;
                }
                case PORTABLE: {
                    if (value instanceof RowValue) {
                        QueryDataType fieldQDT = queryDataType.getObjectFields().get(i).getDataType();
                        ClassDefinition fieldClassDefinition = UpsertTargetUtils.toPortableClassDefinition(fieldQDT);
                        GenericRecordBuilder fieldBuilder = GenericRecordBuilder.portable((ClassDefinition)fieldClassDefinition);
                        UpsertTargetUtils.setPortableFields(fieldBuilder, (RowValue)value, fieldClassDefinition, fieldQDT);
                        builder.setGenericRecord(name, fieldBuilder.build());
                        continue block17;
                    }
                    if (value instanceof GenericRecord) {
                        builder.setGenericRecord(name, (GenericRecord)value);
                        continue block17;
                    }
                    throw QueryException.error((String)("Can not set non-GenericRecord or RowValue to field " + name));
                }
                default: {
                    throw QueryException.error((String)("Unsupported Portable Nested Fields upsert target type: " + field.getType()));
                }
            }
        }
    }

    public static ClassDefinition toPortableClassDefinition(QueryDataType queryDataType) {
        Tuple3<Integer, Integer, Integer> ids = TypesUtils.decodePortableId(queryDataType.getObjectTypeMetadata());
        ClassDefinitionBuilder builder = new ClassDefinitionBuilder(((Integer)ids.f0()).intValue(), ((Integer)ids.f1()).intValue(), ((Integer)ids.f2()).intValue());
        block16: for (int i = 0; i < queryDataType.getObjectFields().size(); ++i) {
            String name = queryDataType.getObjectFields().get(i).getName();
            QueryDataType type = queryDataType.getObjectFields().get(i).getDataType();
            switch (type.getTypeFamily()) {
                case BOOLEAN: {
                    builder.addBooleanField(name);
                    continue block16;
                }
                case TINYINT: {
                    builder.addByteField(name);
                    continue block16;
                }
                case SMALLINT: {
                    builder.addShortField(name);
                    continue block16;
                }
                case INTEGER: {
                    builder.addIntField(name);
                    continue block16;
                }
                case BIGINT: {
                    builder.addLongField(name);
                    continue block16;
                }
                case REAL: {
                    builder.addFloatField(name);
                    continue block16;
                }
                case DOUBLE: {
                    builder.addDoubleField(name);
                    continue block16;
                }
                case DECIMAL: {
                    builder.addDecimalField(name);
                    continue block16;
                }
                case VARCHAR: {
                    builder.addStringField(name);
                    continue block16;
                }
                case TIME: {
                    builder.addTimeField(name);
                    continue block16;
                }
                case DATE: {
                    builder.addDateField(name);
                    continue block16;
                }
                case TIMESTAMP: {
                    builder.addTimestampField(name);
                    continue block16;
                }
                case TIMESTAMP_WITH_TIME_ZONE: {
                    builder.addTimestampWithTimezoneField(name);
                    continue block16;
                }
                case OBJECT: {
                    if (!type.isCustomType()) continue block16;
                    Tuple3<Integer, Integer, Integer> portableFieldIds = TypesUtils.decodePortableId(type.getObjectTypeMetadata());
                    builder.addField(new FieldDefinitionImpl(i, name, FieldType.PORTABLE, ((Integer)portableFieldIds.f0()).intValue(), ((Integer)portableFieldIds.f1()).intValue(), ((Integer)portableFieldIds.f2()).intValue()));
                    continue block16;
                }
                default: {
                    throw QueryException.error((String)("Unsupported Nested Fields Portable data type: " + type));
                }
            }
        }
        return builder.build();
    }

    private static void setCompactFields(RowValue rowValue, QueryDataType targetDataType, GenericRecordBuilder recordBuilder) {
        block16: for (int i = 0; i < targetDataType.getObjectFields().size(); ++i) {
            QueryDataType.QueryDataTypeField field = targetDataType.getObjectFields().get(i);
            Object fieldValue = rowValue.getValues().get(i);
            switch (field.getDataType().getTypeFamily()) {
                case VARCHAR: {
                    recordBuilder.setString(field.getName(), (String)fieldValue);
                    continue block16;
                }
                case BOOLEAN: {
                    recordBuilder.setNullableBoolean(field.getName(), (Boolean)fieldValue);
                    continue block16;
                }
                case TINYINT: {
                    recordBuilder.setNullableInt8(field.getName(), (Byte)fieldValue);
                    continue block16;
                }
                case SMALLINT: {
                    recordBuilder.setNullableInt16(field.getName(), (Short)fieldValue);
                    continue block16;
                }
                case INTEGER: {
                    recordBuilder.setNullableInt32(field.getName(), (Integer)fieldValue);
                    continue block16;
                }
                case BIGINT: {
                    recordBuilder.setNullableInt64(field.getName(), (Long)fieldValue);
                    continue block16;
                }
                case DECIMAL: {
                    recordBuilder.setDecimal(field.getName(), (BigDecimal)fieldValue);
                    continue block16;
                }
                case REAL: {
                    recordBuilder.setNullableFloat32(field.getName(), (Float)fieldValue);
                    continue block16;
                }
                case DOUBLE: {
                    recordBuilder.setNullableFloat64(field.getName(), (Double)fieldValue);
                    continue block16;
                }
                case TIME: {
                    recordBuilder.setTime(field.getName(), (LocalTime)fieldValue);
                    continue block16;
                }
                case DATE: {
                    recordBuilder.setDate(field.getName(), (LocalDate)fieldValue);
                    continue block16;
                }
                case TIMESTAMP: {
                    recordBuilder.setTimestamp(field.getName(), (LocalDateTime)fieldValue);
                    continue block16;
                }
                case TIMESTAMP_WITH_TIME_ZONE: {
                    recordBuilder.setTimestampWithTimezone(field.getName(), (OffsetDateTime)fieldValue);
                    continue block16;
                }
                case OBJECT: {
                    if (fieldValue == null) {
                        recordBuilder.setGenericRecord(field.getName(), null);
                        continue block16;
                    }
                    GenericRecordBuilder nestedRecordBuilder = GenericRecordBuilder.compact((String)field.getDataType().getObjectTypeMetadata());
                    UpsertTargetUtils.setCompactFields((RowValue)fieldValue, field.getDataType(), nestedRecordBuilder);
                    recordBuilder.setGenericRecord(field.getName(), nestedRecordBuilder.build());
                    continue block16;
                }
                default: {
                    throw QueryException.error((String)("Unsupported upsert type: " + field.getDataType()));
                }
            }
        }
    }
}

