/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.metadata;

import com.hazelcast.jet.sql.impl.opt.FullScan;
import com.hazelcast.jet.sql.impl.opt.SlidingWindow;
import com.hazelcast.jet.sql.impl.opt.logical.DropLateItemsLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.WatermarkLogicalRel;
import com.hazelcast.jet.sql.impl.opt.metadata.HazelcastRelMetadataQuery;
import com.hazelcast.jet.sql.impl.opt.metadata.WatermarkedFields;
import com.hazelcast.jet.sql.impl.opt.physical.DropLateItemsPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.JoinHashPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.JoinNestedLoopPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.SlidingWindowAggregatePhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.StreamToStreamJoinPhysicalRel;
import com.hazelcast.jet.sql.impl.validate.ValidationUtil;
import com.hazelcast.shaded.com.google.common.collect.ImmutableSet;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Types;
import com.hazelcast.shaded.org.apache.calcite.plan.hep.HepRelVertex;
import com.hazelcast.shaded.org.apache.calcite.plan.volcano.RelSubset;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Aggregate;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Calc;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Join;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Union;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.Metadata;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.MetadataDef;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.MetadataHandler;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMetadataProvider;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.shaded.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableBitSet;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class HazelcastRelMdWatermarkedFields
implements MetadataHandler<WatermarkedFieldsMetadata> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(WatermarkedFieldsMetadata.METHOD, new HazelcastRelMdWatermarkedFields());

    private HazelcastRelMdWatermarkedFields() {
    }

    @Override
    public MetadataDef<WatermarkedFieldsMetadata> getDef() {
        return WatermarkedFieldsMetadata.DEF;
    }

    public WatermarkedFields extractWatermarkedFields(FullScan rel, RelMetadataQuery mq) {
        return HazelcastRelMdWatermarkedFields.watermarkedFieldByIndex(rel.watermarkedColumnIndex());
    }

    public WatermarkedFields extractWatermarkedFields(WatermarkLogicalRel rel) {
        return HazelcastRelMdWatermarkedFields.watermarkedFieldByIndex(rel.watermarkedColumnIndex());
    }

    @Nullable
    public static WatermarkedFields watermarkedFieldByIndex(int watermarkedFieldIndex) {
        if (watermarkedFieldIndex < 0) {
            return null;
        }
        return new WatermarkedFields(ImmutableSet.of(Integer.valueOf(watermarkedFieldIndex)));
    }

    public WatermarkedFields extractWatermarkedFields(SlidingWindow rel, RelMetadataQuery mq) {
        HazelcastRelMetadataQuery query = HazelcastRelMetadataQuery.reuseOrCreate(mq);
        return query.extractWatermarkedFields(rel.getInput());
    }

    public WatermarkedFields extractWatermarkedFields(Calc rel, RelMetadataQuery mq) {
        HazelcastRelMetadataQuery query = HazelcastRelMetadataQuery.reuseOrCreate(mq);
        WatermarkedFields inputWmFields = query.extractWatermarkedFields(rel.getInput());
        if (inputWmFields == null) {
            return null;
        }
        HashSet<Integer> outputWmFields = new HashSet<Integer>();
        List<RexNode> projectList = rel.getProgram().expandList(rel.getProgram().getProjectList());
        for (int i = 0; i < projectList.size(); ++i) {
            RexNode project = projectList.get(i);
            RexNode project2 = ValidationUtil.unwrapAsOperatorOperand(project);
            if (!(project2 instanceof RexInputRef)) continue;
            int index = ((RexInputRef)project2).getIndex();
            if (!inputWmFields.getFieldIndexes().contains(index)) continue;
            outputWmFields.add(i);
        }
        return new WatermarkedFields(outputWmFields);
    }

    public WatermarkedFields extractWatermarkedFields(SlidingWindowAggregatePhysicalRel rel, RelMetadataQuery mq) {
        return rel.watermarkedFields();
    }

    public WatermarkedFields extractWatermarkedFields(Aggregate rel, RelMetadataQuery mq) {
        HazelcastRelMetadataQuery query = HazelcastRelMetadataQuery.reuseOrCreate(mq);
        WatermarkedFields inputWmFields = query.extractWatermarkedFields(rel.getInput());
        if (inputWmFields == null || rel.getGroupSets().size() != 1) {
            return null;
        }
        Iterator<Integer> groupedIndexes = ((ImmutableBitSet)rel.getGroupSets().get(0)).iterator();
        HashSet<Integer> outputProperties = new HashSet<Integer>();
        int outputIndex = 0;
        while (groupedIndexes.hasNext()) {
            int groupedBy = groupedIndexes.next();
            if (inputWmFields.getFieldIndexes().contains(groupedBy)) {
                outputProperties.add(outputIndex);
            }
            ++outputIndex;
        }
        return new WatermarkedFields(outputProperties);
    }

    public WatermarkedFields extractWatermarkedFields(Join rel, RelMetadataQuery mq) {
        HazelcastRelMetadataQuery query = HazelcastRelMetadataQuery.reuseOrCreate(mq);
        if (rel instanceof JoinNestedLoopPhysicalRel || rel instanceof JoinHashPhysicalRel) {
            return query.extractWatermarkedFields(rel.getLeft());
        }
        if (rel instanceof StreamToStreamJoinPhysicalRel) {
            WatermarkedFields leftWmFields = query.extractWatermarkedFields(rel.getLeft());
            WatermarkedFields rightWmFields = query.extractWatermarkedFields(rel.getRight());
            int offset = rel.getLeft().getRowType().getFieldList().size();
            Set<Integer> shiftedRightProps = rightWmFields.getFieldIndexes().stream().map(idx -> idx + offset).collect(Collectors.toSet());
            return leftWmFields.union(new WatermarkedFields(shiftedRightProps));
        }
        throw new RuntimeException("Unknown join rel: " + rel.getClass().getName());
    }

    public WatermarkedFields extractWatermarkedFields(Union rel, RelMetadataQuery mq) {
        HazelcastRelMetadataQuery query = HazelcastRelMetadataQuery.reuseOrCreate(mq);
        assert (!rel.getInputs().isEmpty());
        HashSet<Integer> wmFields = new HashSet<Integer>();
        for (int i = 0; i < rel.getInputs().size(); ++i) {
            WatermarkedFields wmFields2 = query.extractWatermarkedFields(rel.getInputs().get(i));
            if (wmFields2 == null) {
                return null;
            }
            if (i == 0) {
                wmFields.addAll(wmFields2.getFieldIndexes());
                continue;
            }
            wmFields.retainAll(wmFields2.getFieldIndexes());
        }
        return new WatermarkedFields(wmFields);
    }

    public WatermarkedFields extractWatermarkedFields(DropLateItemsLogicalRel rel, RelMetadataQuery mq) {
        HazelcastRelMetadataQuery query = HazelcastRelMetadataQuery.reuseOrCreate(mq);
        return query.extractWatermarkedFields(rel.getInput());
    }

    public WatermarkedFields extractWatermarkedFields(DropLateItemsPhysicalRel rel, RelMetadataQuery mq) {
        HazelcastRelMetadataQuery query = HazelcastRelMetadataQuery.reuseOrCreate(mq);
        return query.extractWatermarkedFields(rel.getInput());
    }

    public WatermarkedFields extractWatermarkedFields(RelSubset subset, RelMetadataQuery mq) {
        HazelcastRelMetadataQuery query = HazelcastRelMetadataQuery.reuseOrCreate(mq);
        RelNode rel = subset.getBestOrOriginal();
        return query.extractWatermarkedFields(rel);
    }

    public WatermarkedFields extractWatermarkedFields(HepRelVertex vertex, RelMetadataQuery mq) {
        HazelcastRelMetadataQuery query = HazelcastRelMetadataQuery.reuseOrCreate(mq);
        RelNode rel = vertex.getCurrentRel();
        return query.extractWatermarkedFields(rel);
    }

    public WatermarkedFields extractWatermarkedFields(RelNode rel, RelMetadataQuery mq) {
        return null;
    }

    public static interface WatermarkedFieldsMetadata
    extends Metadata {
        public static final Method METHOD = Types.lookupMethod(WatermarkedFieldsMetadata.class, "extractWatermarkedFields", new Class[0]);
        public static final MetadataDef<WatermarkedFieldsMetadata> DEF = MetadataDef.of(WatermarkedFieldsMetadata.class, Handler.class, METHOD);

        public WatermarkedFields extractWatermarkedFields();

        public static interface Handler
        extends MetadataHandler<WatermarkedFieldsMetadata> {
            public WatermarkedFields extractWatermarkedFields(RelNode var1, RelMetadataQuery var2);
        }
    }
}

