/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.config.DeltaJobConfig;
import com.hazelcast.jet.sql.impl.parse.ParserResource;
import com.hazelcast.jet.sql.impl.parse.SqlCreateJob;
import com.hazelcast.jet.sql.impl.parse.SqlOption;
import com.hazelcast.jet.sql.impl.parse.UnparseUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlAlter;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableNullableList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SqlAlterJob
extends SqlAlter {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("ALTER JOB", SqlKind.OTHER_DDL);
    private final SqlIdentifier name;
    private final SqlNodeList options;
    private final AlterJobOperation operation;
    private final DeltaJobConfig deltaConfig;

    public SqlAlterJob(SqlIdentifier name, SqlNodeList options, @Nullable AlterJobOperation operation, SqlParserPos pos) {
        super(pos, "JOB");
        this.name = Objects.requireNonNull(name, "Name must not be null");
        this.options = options;
        this.operation = operation;
        Preconditions.checkTrue((name.names.size() == 1 ? 1 : 0) != 0, (String)name.toString());
        Preconditions.checkTrueUnsupportedOperation((options == null || operation == null || operation == AlterJobOperation.RESUME ? 1 : 0) != 0, (String)"Options can only be specified for RESUME operation");
        this.deltaConfig = options == null || options.isEmpty() ? null : new DeltaJobConfig();
    }

    public String name() {
        return this.name.toString();
    }

    @Nullable
    public DeltaJobConfig getDeltaConfig() {
        return this.deltaConfig;
    }

    @Nullable
    public AlterJobOperation getOperation() {
        return this.operation;
    }

    @Override
    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name, this.options);
    }

    @Override
    protected void unparseAlterOperation(SqlWriter writer, int leftPrec, int rightPrec) {
        this.name.unparse(writer, leftPrec, rightPrec);
        UnparseUtil.unparseOptions(writer, this.options);
        if (this.operation != null) {
            writer.keyword(this.operation.name());
        }
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        if (this.options == null) {
            return;
        }
        HashSet<String> optionNames = new HashSet<String>();
        block21: for (SqlNode option0 : this.options) {
            SqlOption option = (SqlOption)option0;
            String key = option.keyString();
            String value = option.valueString();
            if (!optionNames.add(key)) {
                throw validator.newValidationError(option, ParserResource.RESOURCE.duplicateOption(key));
            }
            switch (key) {
                case "snapshotIntervalMillis": {
                    this.deltaConfig.setSnapshotIntervalMillis(SqlCreateJob.parseLong(validator, option));
                    continue block21;
                }
                case "autoScaling": {
                    this.deltaConfig.setAutoScaling(Boolean.parseBoolean(value));
                    continue block21;
                }
                case "splitBrainProtectionEnabled": {
                    this.deltaConfig.setSplitBrainProtection(Boolean.parseBoolean(value));
                    continue block21;
                }
                case "metricsEnabled": {
                    this.deltaConfig.setMetricsEnabled(Boolean.parseBoolean(value));
                    continue block21;
                }
                case "storeMetricsAfterJobCompletion": {
                    this.deltaConfig.setStoreMetricsAfterJobCompletion(Boolean.parseBoolean(value));
                    continue block21;
                }
                case "maxProcessorAccumulatedRecords": {
                    this.deltaConfig.setMaxProcessorAccumulatedRecords(SqlCreateJob.parseLong(validator, option));
                    continue block21;
                }
                case "suspendOnFailure": {
                    this.deltaConfig.setSuspendOnFailure(Boolean.parseBoolean(value));
                    continue block21;
                }
                case "processingGuarantee": 
                case "initialSnapshotName": {
                    throw validator.newValidationError(option.key(), ParserResource.RESOURCE.notSupported(key, "ALTER JOB"));
                }
            }
            throw validator.newValidationError(option.key(), ParserResource.RESOURCE.unknownJobOption(key));
        }
    }

    public static enum AlterJobOperation {
        SUSPEND,
        RESUME,
        RESTART;

    }
}

