/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDrop;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableNullableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SqlDropSnapshot
extends SqlDrop {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("DROP SNAPSHOT", SqlKind.OTHER_DDL);
    private final SqlIdentifier snapshotName;
    private final boolean ifExists;

    public SqlDropSnapshot(SqlIdentifier snapshotName, boolean ifExists, SqlParserPos pos) {
        super(OPERATOR, pos, true);
        this.snapshotName = Objects.requireNonNull(snapshotName, "Snapshot name must not be null");
        this.ifExists = ifExists;
        Preconditions.checkTrue((snapshotName.names.size() == 1 ? 1 : 0) != 0, (String)snapshotName.toString());
    }

    public String getSnapshotName() {
        return this.snapshotName.toString();
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    @Override
    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.snapshotName);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DROP SNAPSHOT");
        this.snapshotName.unparse(writer, leftPrec, rightPrec);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
    }
}

