/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.dataconnection.impl.InternalDataConnectionService;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.function.QuadFunction;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorCache;
import com.hazelcast.jet.sql.impl.connector.infoschema.MappingColumnsTable;
import com.hazelcast.jet.sql.impl.connector.infoschema.MappingsTable;
import com.hazelcast.jet.sql.impl.connector.infoschema.TablesTable;
import com.hazelcast.jet.sql.impl.connector.infoschema.UDTAttributesTable;
import com.hazelcast.jet.sql.impl.connector.infoschema.UserDefinedTypesTable;
import com.hazelcast.jet.sql.impl.connector.infoschema.ViewsTable;
import com.hazelcast.jet.sql.impl.connector.virtual.ViewTable;
import com.hazelcast.jet.sql.impl.schema.AbstractSchemaStorage;
import com.hazelcast.jet.sql.impl.schema.RelationsStorage;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.schema.BadTable;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.Mapping;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableResolver;
import com.hazelcast.sql.impl.schema.dataconnection.DataConnectionCatalogEntry;
import com.hazelcast.sql.impl.schema.type.Type;
import com.hazelcast.sql.impl.schema.view.View;
import com.hazelcast.sql.impl.security.SqlSecurityContext;
import java.io.Serializable;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;

public class TableResolverImpl
implements TableResolver {
    private static final List<List<String>> SEARCH_PATHS = Collections.singletonList(Arrays.asList("hazelcast", "public"));
    private static final List<QuadFunction<List<Mapping>, List<View>, List<Type>, NodeEngine, Table>> ADDITIONAL_TABLE_PRODUCERS = Arrays.asList((QuadFunction & Serializable)(m4, v, t2, hz) -> new TablesTable("hazelcast", "information_schema", "public", (Collection<Mapping>)m4, (Collection<View>)v), (QuadFunction & Serializable)(m4, v, t2, hz) -> new MappingsTable("hazelcast", "information_schema", "public", (Collection<Mapping>)m4, arg_0 -> ((InternalDataConnectionService)hz.getDataConnectionService()).typeForDataConnection(arg_0), hz.getConfig().getSecurityConfig().isEnabled()), (QuadFunction & Serializable)(m4, v, t2, hz) -> new MappingColumnsTable("hazelcast", "information_schema", "public", (Collection<Mapping>)m4, (Collection<View>)v), (QuadFunction & Serializable)(m4, v, t2, hz) -> new ViewsTable("hazelcast", "information_schema", "public", (Collection<View>)v), (QuadFunction & Serializable)(m4, v, t2, hz) -> new UserDefinedTypesTable("hazelcast", "information_schema", "public", (List<Type>)t2), (QuadFunction & Serializable)(m4, v, t2, hz) -> new UDTAttributesTable("hazelcast", "information_schema", "public", (List<Type>)t2));
    private final NodeEngine nodeEngine;
    private final RelationsStorage relationsStorage;
    private final SqlConnectorCache connectorCache;
    private final List<TableResolver.TableListener> listeners;
    private int lastViewsSize;
    private int lastMappingsSize;
    private int lastTypesSize;

    public TableResolverImpl(NodeEngine nodeEngine, RelationsStorage relationsStorage, SqlConnectorCache connectorCache) {
        this.nodeEngine = nodeEngine;
        this.relationsStorage = relationsStorage;
        this.connectorCache = connectorCache;
        this.listeners = new CopyOnWriteArrayList<TableResolver.TableListener>();
        nodeEngine.getHazelcastInstance().getLifecycleService().addLifecycleListener(event -> {
            if (event.getState() == LifecycleEvent.LifecycleState.STARTED) {
                this.relationsStorage.initializeWithListener(new AbstractSchemaStorage.EntryListenerAdapter(){

                    @Override
                    public void entryUpdated(EntryEvent<String, Object> event) {
                        if (!event.getMember().localMember()) {
                            TableResolverImpl.this.listeners.forEach(TableResolver.TableListener::onTableChanged);
                        }
                    }

                    @Override
                    public void entryRemoved(EntryEvent<String, Object> event) {
                        if (!event.getMember().localMember()) {
                            TableResolverImpl.this.listeners.forEach(TableResolver.TableListener::onTableChanged);
                        }
                    }
                });
            }
        });
    }

    public void createMapping(Mapping mapping, boolean replace, boolean ifNotExists, SqlSecurityContext securityContext) {
        Mapping resolved = this.resolveMapping(mapping, securityContext);
        String name = resolved.name();
        if (ifNotExists) {
            this.relationsStorage.putIfAbsent(name, resolved);
        } else if (replace) {
            this.relationsStorage.put(name, resolved);
            this.listeners.forEach(TableResolver.TableListener::onTableChanged);
        } else if (!this.relationsStorage.putIfAbsent(name, resolved)) {
            throw QueryException.error((String)("Mapping or view already exists: " + name));
        }
    }

    private Mapping resolveMapping(Mapping mapping, SqlSecurityContext securityContext) {
        Map<String, String> options = mapping.options();
        String type = mapping.connectorType();
        String dataConnection = mapping.dataConnection();
        SqlConnector connector = type == null ? this.extractConnector(dataConnection) : this.connectorCache.forType(type);
        String objectType = mapping.objectType() == null ? connector.defaultObjectType() : mapping.objectType();
        Preconditions.checkNotNull((Object)objectType, (String)"objectType cannot be null");
        SqlConnector.SqlExternalResource externalResource = new SqlConnector.SqlExternalResource(mapping.externalName(), mapping.dataConnection(), connector.typeName(), objectType, options);
        List<Permission> permissions = connector.permissionsForResolve(externalResource, this.nodeEngine);
        for (Permission permission : permissions) {
            securityContext.checkPermission(permission);
        }
        List<MappingField> resolvedFields = connector.resolveAndValidateFields(this.nodeEngine, externalResource, mapping.fields());
        return new Mapping(mapping.name(), mapping.externalName(), mapping.dataConnection(), type, objectType, new ArrayList<MappingField>(resolvedFields), new LinkedHashMap<String, String>(options));
    }

    private SqlConnector extractConnector(@Nonnull String dataConnection) {
        InternalDataConnectionService dataConnectionService = this.nodeEngine.getDataConnectionService();
        String type = dataConnectionService.typeForDataConnection(dataConnection);
        return this.connectorCache.forType(type);
    }

    public void removeMapping(String name, boolean ifExists) {
        if (this.relationsStorage.removeMapping(name) != null) {
            this.listeners.forEach(TableResolver.TableListener::onTableChanged);
        } else if (!ifExists) {
            throw QueryException.error((String)("Mapping does not exist: " + name));
        }
    }

    @Nonnull
    public Collection<String> getMappingNames() {
        return this.relationsStorage.mappingNames();
    }

    public void createView(View view, boolean replace, boolean ifNotExists) {
        if (ifNotExists) {
            this.relationsStorage.putIfAbsent(view.name(), view);
        } else if (replace) {
            this.relationsStorage.put(view.name(), view);
        } else if (!this.relationsStorage.putIfAbsent(view.name(), view)) {
            throw QueryException.error((String)("Mapping or view already exists: " + view.name()));
        }
    }

    public void removeView(String name, boolean ifExists) {
        if (this.relationsStorage.removeView(name) == null && !ifExists) {
            throw QueryException.error((String)("View does not exist: " + name));
        }
    }

    @Nonnull
    public Collection<String> getViewNames() {
        return this.relationsStorage.viewNames();
    }

    public Collection<String> getTypeNames() {
        return this.relationsStorage.typeNames();
    }

    public Collection<Type> getTypes() {
        return this.relationsStorage.getAllTypes();
    }

    public void createType(Type type, boolean replace, boolean ifNotExists) {
        if (ifNotExists) {
            this.relationsStorage.putIfAbsent(type.getName(), type);
        } else if (replace) {
            this.relationsStorage.put(type.getName(), type);
        } else if (!this.relationsStorage.putIfAbsent(type.getName(), type)) {
            throw QueryException.error((String)("Type already exists: " + type.getName()));
        }
    }

    public void removeType(String name, boolean ifExists) {
        if (this.relationsStorage.removeType(name) == null && !ifExists) {
            throw QueryException.error((String)("Type does not exist: " + name));
        }
    }

    @Override
    @Nonnull
    public List<List<String>> getDefaultSearchPaths() {
        return SEARCH_PATHS;
    }

    @Override
    @Nonnull
    public List<Table> getTables() {
        Collection<Object> objects = this.relationsStorage.allObjects();
        ArrayList<Table> tables = new ArrayList<Table>(objects.size() + ADDITIONAL_TABLE_PRODUCERS.size());
        int lastMappingsSize = this.lastMappingsSize;
        int lastViewsSize = this.lastViewsSize;
        int lastTypesSize = this.lastTypesSize;
        ArrayList<Mapping> mappings = lastMappingsSize == 0 ? new ArrayList<Mapping>() : new ArrayList(lastMappingsSize);
        ArrayList<View> views = lastViewsSize == 0 ? new ArrayList<View>() : new ArrayList(lastViewsSize);
        ArrayList<Type> types = lastTypesSize == 0 ? new ArrayList<Type>() : new ArrayList(lastTypesSize);
        for (Object o : objects) {
            if (o instanceof Mapping) {
                tables.add(this.toTable((Mapping)o));
                mappings.add((Mapping)o);
                continue;
            }
            if (o instanceof View) {
                tables.add(this.toTable((View)o));
                views.add((View)o);
                continue;
            }
            if (o instanceof Type) {
                types.add((Type)o);
                continue;
            }
            if (o instanceof DataConnectionCatalogEntry) continue;
            throw new RuntimeException("Unexpected: " + o);
        }
        ADDITIONAL_TABLE_PRODUCERS.forEach(producer -> tables.add((Table)producer.apply((Object)mappings, (Object)views, (Object)types, (Object)this.nodeEngine)));
        this.lastViewsSize = views.size();
        this.lastMappingsSize = mappings.size();
        this.lastTypesSize = types.size();
        return tables;
    }

    private Table toTable(Mapping mapping) {
        try {
            SqlConnector connector = mapping.connectorType() == null ? this.extractConnector(mapping.dataConnection()) : this.connectorCache.forType(mapping.connectorType());
            assert (connector != null);
            return connector.createTable(this.nodeEngine, "public", mapping.name(), TableResolverImpl.sqlExternalResourceFrom(mapping, connector), mapping.fields());
        }
        catch (Throwable e) {
            return new BadTable("public", mapping.name(), mapping.objectType(), e);
        }
    }

    private static SqlConnector.SqlExternalResource sqlExternalResourceFrom(Mapping internalMapping, SqlConnector connector) {
        String internalObjType = internalMapping.objectType() == null ? connector.defaultObjectType() : internalMapping.objectType();
        Preconditions.checkNotNull((Object)internalObjType, (String)"objectType cannot be null");
        String connectorType = connector.typeName();
        return new SqlConnector.SqlExternalResource(internalMapping.externalName(), internalMapping.dataConnection(), connectorType, internalObjType, internalMapping.options());
    }

    private Table toTable(View view) {
        return new ViewTable("public", view.name(), view.query(), new ConstantTableStatistics(0L));
    }

    @Override
    public void registerListener(TableResolver.TableListener listener) {
        this.listeners.add(listener);
    }
}

