/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate;

import com.hazelcast.dataconnection.impl.InternalDataConnectionService;
import com.hazelcast.jet.sql.impl.JetSqlSerializerHook;
import com.hazelcast.jet.sql.impl.schema.DataConnectionStorage;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.sql.impl.schema.dataconnection.DataConnectionCatalogEntry;
import java.io.IOException;

public class UpdateDataConnectionOperation
extends Operation
implements IdentifiedDataSerializable {
    private String dataConnectionName;

    public UpdateDataConnectionOperation() {
    }

    public UpdateDataConnectionOperation(String dataConnectionName) {
        this.dataConnectionName = dataConnectionName;
    }

    public void run() throws Exception {
        InternalDataConnectionService dlService = this.getNodeEngine().getDataConnectionService();
        DataConnectionStorage storage = new DataConnectionStorage(this.getNodeEngine());
        DataConnectionCatalogEntry entry = storage.get(this.dataConnectionName);
        if (entry != null) {
            dlService.createOrReplaceSqlDataConnection(entry.name(), entry.type(), entry.isShared(), entry.options());
        } else {
            dlService.removeDataConnection(this.dataConnectionName);
        }
    }

    public int getFactoryId() {
        return JetSqlSerializerHook.F_ID;
    }

    public int getClassId() {
        return 80;
    }

    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeString(this.dataConnectionName);
    }

    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.dataConnectionName = in.readString();
    }
}

