/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.linq4j.tree;

import com.hazelcast.shaded.org.apache.calcite.linq4j.Ord;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Blocks;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.DeclarationStatement;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Expression;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.ExpressionType;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.ExpressionWriter;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Expressions;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Shuttle;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Statement;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Visitor;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;
import java.util.Objects;

public class ForStatement
extends Statement {
    public final List<DeclarationStatement> declarations;
    public final @Nullable Expression condition;
    public final @Nullable Expression post;
    public final Statement body;
    private int hash;

    public ForStatement(List<DeclarationStatement> declarations, @Nullable Expression condition, @Nullable Expression post, Statement body) {
        super(ExpressionType.For, Void.TYPE);
        assert (declarations != null);
        assert (body != null);
        this.declarations = declarations;
        this.condition = condition;
        this.post = post;
        this.body = body;
    }

    @Override
    public ForStatement accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        List<DeclarationStatement> decls1 = Expressions.acceptDeclarations(this.declarations, shuttle);
        Expression condition1 = this.condition == null ? null : this.condition.accept(shuttle);
        Expression post1 = this.post == null ? null : this.post.accept(shuttle);
        Statement body1 = this.body.accept(shuttle);
        return shuttle.visit(this, decls1, condition1, post1, body1);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    void accept0(ExpressionWriter writer) {
        writer.append("for (");
        for (Ord<DeclarationStatement> declaration : Ord.zip(this.declarations)) {
            ((DeclarationStatement)declaration.e).accept2(writer, declaration.i == 0);
        }
        writer.append("; ");
        if (this.condition != null) {
            writer.append(this.condition);
        }
        writer.append("; ");
        if (this.post != null) {
            writer.append(this.post);
        }
        writer.append(") ").append(Blocks.toBlock(this.body));
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ForStatement that = (ForStatement)o;
        if (!this.body.equals(that.body)) {
            return false;
        }
        if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) {
            return false;
        }
        if (!this.declarations.equals(that.declarations)) {
            return false;
        }
        return !(this.post != null ? !this.post.equals(that.post) : that.post != null);
    }

    @Override
    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            result = Objects.hash(new Object[]{this.nodeType, this.type, this.declarations, this.condition, this.post, this.body});
            if (result == 0) {
                result = 1;
            }
            this.hash = result;
        }
        return result;
    }
}

