/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql;

import com.hazelcast.shaded.org.apache.calcite.linq4j.Nullness;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.util.SqlVisitor;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlMoniker;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlMonotonicity;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorImpl;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.shaded.org.apache.calcite.util.Litmus;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import com.hazelcast.shaded.org.checkerframework.dataflow.qual.Pure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public abstract class SqlCall
extends SqlNode {
    protected SqlCall(SqlParserPos pos) {
        super(pos);
    }

    public boolean isExpanded() {
        return false;
    }

    public void setOperand(int i, @Nullable SqlNode operand) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SqlKind getKind() {
        return this.getOperator().getKind();
    }

    @Pure
    public abstract SqlOperator getOperator();

    public abstract List<SqlNode> getOperandList();

    public <S extends SqlNode> S operand(int i) {
        return (S)Nullness.castNonNull(this.getOperandList().get(i));
    }

    public int operandCount() {
        return this.getOperandList().size();
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return this.getOperator().createCall(this.getFunctionQuantifier(), pos, this.getOperandList());
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlOperator operator = this.getOperator();
        SqlDialect dialect = writer.getDialect();
        if (leftPrec > operator.getLeftPrec() || operator.getRightPrec() <= rightPrec && rightPrec != 0 || writer.isAlwaysUseParentheses() && this.isA(SqlKind.EXPRESSION)) {
            SqlWriter.Frame frame = writer.startList("(", ")");
            dialect.unparseCall(writer, this, 0, 0);
            writer.endList(frame);
        } else {
            dialect.unparseCall(writer, this, leftPrec, rightPrec);
        }
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateCall(this, scope);
    }

    @Override
    public void findValidOptions(SqlValidator validator, SqlValidatorScope scope, SqlParserPos pos, Collection<SqlMoniker> hintList) {
        for (SqlNode operand : this.getOperandList()) {
            SqlIdentifier id;
            SqlParserPos idPos;
            if (!(operand instanceof SqlIdentifier) || !(idPos = (id = (SqlIdentifier)operand).getParserPosition()).toString().equals(pos.toString())) continue;
            ((SqlValidatorImpl)validator).lookupNameCompletionHints(scope, id.names, pos, hintList);
            return;
        }
    }

    @Override
    public <R> R accept(SqlVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equalsDeep(@Nullable SqlNode node, Litmus litmus) {
        if (node == this) {
            return true;
        }
        if (!(node instanceof SqlCall)) {
            return litmus.fail("{} != {}", this, node);
        }
        SqlCall that = (SqlCall)node;
        if (!this.getOperator().getName().equalsIgnoreCase(that.getOperator().getName())) {
            return litmus.fail("{} != {}", this, node);
        }
        if (!SqlCall.equalDeep(this.getFunctionQuantifier(), that.getFunctionQuantifier(), litmus)) {
            return litmus.fail("{} != {} (function quantifier differs)", this, node);
        }
        return SqlCall.equalDeep(this.getOperandList(), that.getOperandList(), litmus);
    }

    protected String getCallSignature(SqlValidator validator, @Nullable SqlValidatorScope scope) {
        ArrayList<String> signatureList = new ArrayList<String>();
        for (SqlNode operand : this.getOperandList()) {
            RelDataType argType = validator.deriveType(Objects.requireNonNull(scope, "scope"), operand);
            if (null == argType) continue;
            signatureList.add(argType.toString());
        }
        return SqlUtil.getOperatorSignature(this.getOperator(), signatureList);
    }

    @Override
    public SqlMonotonicity getMonotonicity(@Nullable SqlValidatorScope scope) {
        Objects.requireNonNull(scope, "scope");
        SqlCallBinding binding = new SqlCallBinding(scope.getValidator(), scope, this);
        return this.getOperator().getMonotonicity(binding);
    }

    public boolean isCountStar() {
        SqlIdentifier id;
        Object parm;
        SqlOperator sqlOperator = this.getOperator();
        return sqlOperator.getName().equals("COUNT") && this.operandCount() == 1 && (parm = this.operand(0)) instanceof SqlIdentifier && (id = (SqlIdentifier)parm).isStar() && id.names.size() == 1;
    }

    @Pure
    public @Nullable SqlLiteral getFunctionQuantifier() {
        return null;
    }
}

