/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.util.SqlBasicVisitor;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorUtil;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableNullableList;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class SqlPivot
extends SqlCall {
    public SqlNode query;
    public final SqlNodeList aggList;
    public final SqlNodeList axisList;
    public final SqlNodeList inList;
    static final Operator OPERATOR = new Operator(SqlKind.PIVOT);

    public SqlPivot(SqlParserPos pos, SqlNode query, SqlNodeList aggList, SqlNodeList axisList, SqlNodeList inList) {
        super(pos);
        this.query = Objects.requireNonNull(query, "query");
        this.aggList = Objects.requireNonNull(aggList, "aggList");
        this.axisList = Objects.requireNonNull(axisList, "axisList");
        this.inList = Objects.requireNonNull(inList, "inList");
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.query, this.aggList, this.axisList, this.inList);
    }

    @Override
    public void setOperand(int i, @Nullable SqlNode operand) {
        switch (i) {
            case 0: {
                this.query = operand;
                break;
            }
            default: {
                super.setOperand(i, operand);
            }
        }
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.query.unparse(writer, leftPrec, 0);
        writer.keyword("PIVOT");
        SqlWriter.Frame frame = writer.startList("(", ")");
        this.aggList.unparse(writer, 0, 0);
        writer.sep("FOR");
        int leftPrec1 = this.axisList.size() > 1 ? 1 : 0;
        this.axisList.unparse(writer, leftPrec1, 0);
        writer.sep("IN");
        writer.list(SqlWriter.FrameTypeEnum.PARENTHESES, SqlWriter.COMMA, SqlPivot.stripList(this.inList));
        writer.endList(frame);
    }

    static SqlNodeList stripList(SqlNodeList list) {
        return list.stream().map(SqlPivot::strip).collect(SqlNode.toList(list.pos));
    }

    private static SqlNode strip(SqlNode e) {
        switch (e.getKind()) {
            case AS: {
                SqlCall call = (SqlCall)e;
                List<SqlNode> operands = call.getOperandList();
                return SqlStdOperatorTable.AS.createCall(e.pos, SqlPivot.strip(operands.get(0)), operands.get(1));
            }
        }
        if (e instanceof SqlNodeList && ((SqlNodeList)e).size() == 1) {
            return ((SqlNodeList)e).get(0);
        }
        return e;
    }

    public void forEachAgg(BiConsumer<@Nullable String, SqlNode> consumer) {
        for (SqlNode agg : this.aggList) {
            SqlNode call = SqlUtil.stripAs(agg);
            String alias = SqlValidatorUtil.getAlias(agg, -1);
            consumer.accept(alias, call);
        }
    }

    public void forEachNameValues(BiConsumer<String, SqlNodeList> consumer) {
        for (SqlNode node : this.inList) {
            String alias;
            if (node.getKind() == SqlKind.AS) {
                List<SqlNode> operands = ((SqlCall)node).getOperandList();
                alias = ((SqlIdentifier)operands.get(1)).getSimple();
                node = operands.get(0);
            } else {
                alias = SqlPivot.pivotAlias(node);
            }
            consumer.accept(alias, SqlPivot.toNodes(node));
        }
    }

    static String pivotAlias(SqlNode node) {
        if (node instanceof SqlNodeList) {
            return ((SqlNodeList)node).stream().map(SqlPivot::pivotAlias).collect(Collectors.joining("_"));
        }
        return node.toString();
    }

    static SqlNodeList toNodes(SqlNode node) {
        if (node instanceof SqlNodeList) {
            return (SqlNodeList)node;
        }
        return new SqlNodeList(ImmutableList.of(node), node.getParserPosition());
    }

    public Set<String> usedColumnNames() {
        final HashSet<String> columnNames = new HashSet<String>();
        SqlBasicVisitor<Void> nameCollector = new SqlBasicVisitor<Void>(){

            @Override
            public Void visit(SqlIdentifier id) {
                columnNames.add(Util.last(id.names));
                return (Void)super.visit(id);
            }
        };
        for (SqlNode agg : this.aggList) {
            SqlCall call = (SqlCall)SqlUtil.stripAs(agg);
            call.accept(nameCollector);
        }
        for (SqlNode axis : this.axisList) {
            axis.accept(nameCollector);
        }
        return columnNames;
    }

    static class Operator
    extends SqlSpecialOperator {
        Operator(SqlKind kind) {
            super(kind.name(), kind);
        }
    }
}

