/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.geom;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateList;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequence;
import com.hazelcast.shaded.org.locationtech.jts.geom.Envelope;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryComponentFilter;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineString;
import com.hazelcast.shaded.org.locationtech.jts.geom.Point;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;

public class OctagonalEnvelope {
    private static double SQRT2 = Math.sqrt(2.0);
    private double minX = Double.NaN;
    private double maxX;
    private double minY;
    private double maxY;
    private double minA;
    private double maxA;
    private double minB;
    private double maxB;

    public static Geometry octagonalEnvelope(Geometry geom) {
        return new OctagonalEnvelope(geom).toGeometry(geom.getFactory());
    }

    private static double computeA(double x, double y) {
        return x + y;
    }

    private static double computeB(double x, double y) {
        return x - y;
    }

    public OctagonalEnvelope() {
    }

    public OctagonalEnvelope(Coordinate p) {
        this.expandToInclude(p);
    }

    public OctagonalEnvelope(Coordinate p0, Coordinate p1) {
        this.expandToInclude(p0);
        this.expandToInclude(p1);
    }

    public OctagonalEnvelope(Envelope env) {
        this.expandToInclude(env);
    }

    public OctagonalEnvelope(OctagonalEnvelope oct) {
        this.expandToInclude(oct);
    }

    public OctagonalEnvelope(Geometry geom) {
        this.expandToInclude(geom);
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getMinA() {
        return this.minA;
    }

    public double getMaxA() {
        return this.maxA;
    }

    public double getMinB() {
        return this.minB;
    }

    public double getMaxB() {
        return this.maxB;
    }

    public boolean isNull() {
        return Double.isNaN(this.minX);
    }

    public void setToNull() {
        this.minX = Double.NaN;
    }

    public void expandToInclude(Geometry g2) {
        g2.apply(new BoundingOctagonComponentFilter(this));
    }

    public OctagonalEnvelope expandToInclude(CoordinateSequence seq) {
        for (int i = 0; i < seq.size(); ++i) {
            double x = seq.getX(i);
            double y = seq.getY(i);
            this.expandToInclude(x, y);
        }
        return this;
    }

    public OctagonalEnvelope expandToInclude(OctagonalEnvelope oct) {
        if (oct.isNull()) {
            return this;
        }
        if (this.isNull()) {
            this.minX = oct.minX;
            this.maxX = oct.maxX;
            this.minY = oct.minY;
            this.maxY = oct.maxY;
            this.minA = oct.minA;
            this.maxA = oct.maxA;
            this.minB = oct.minB;
            this.maxB = oct.maxB;
            return this;
        }
        if (oct.minX < this.minX) {
            this.minX = oct.minX;
        }
        if (oct.maxX > this.maxX) {
            this.maxX = oct.maxX;
        }
        if (oct.minY < this.minY) {
            this.minY = oct.minY;
        }
        if (oct.maxY > this.maxY) {
            this.maxY = oct.maxY;
        }
        if (oct.minA < this.minA) {
            this.minA = oct.minA;
        }
        if (oct.maxA > this.maxA) {
            this.maxA = oct.maxA;
        }
        if (oct.minB < this.minB) {
            this.minB = oct.minB;
        }
        if (oct.maxB > this.maxB) {
            this.maxB = oct.maxB;
        }
        return this;
    }

    public OctagonalEnvelope expandToInclude(Coordinate p) {
        this.expandToInclude(p.x, p.y);
        return this;
    }

    public OctagonalEnvelope expandToInclude(Envelope env) {
        this.expandToInclude(env.getMinX(), env.getMinY());
        this.expandToInclude(env.getMinX(), env.getMaxY());
        this.expandToInclude(env.getMaxX(), env.getMinY());
        this.expandToInclude(env.getMaxX(), env.getMaxY());
        return this;
    }

    public OctagonalEnvelope expandToInclude(double x, double y) {
        double A2 = OctagonalEnvelope.computeA(x, y);
        double B = OctagonalEnvelope.computeB(x, y);
        if (this.isNull()) {
            this.minX = x;
            this.maxX = x;
            this.minY = y;
            this.maxY = y;
            this.minA = A2;
            this.maxA = A2;
            this.minB = B;
            this.maxB = B;
        } else {
            if (x < this.minX) {
                this.minX = x;
            }
            if (x > this.maxX) {
                this.maxX = x;
            }
            if (y < this.minY) {
                this.minY = y;
            }
            if (y > this.maxY) {
                this.maxY = y;
            }
            if (A2 < this.minA) {
                this.minA = A2;
            }
            if (A2 > this.maxA) {
                this.maxA = A2;
            }
            if (B < this.minB) {
                this.minB = B;
            }
            if (B > this.maxB) {
                this.maxB = B;
            }
        }
        return this;
    }

    public void expandBy(double distance) {
        if (this.isNull()) {
            return;
        }
        double diagonalDistance = SQRT2 * distance;
        this.minX -= distance;
        this.maxX += distance;
        this.minY -= distance;
        this.maxY += distance;
        this.minA -= diagonalDistance;
        this.maxA += diagonalDistance;
        this.minB -= diagonalDistance;
        this.maxB += diagonalDistance;
        if (!this.isValid()) {
            this.setToNull();
        }
    }

    private boolean isValid() {
        if (this.isNull()) {
            return true;
        }
        return this.minX <= this.maxX && this.minY <= this.maxY && this.minA <= this.maxA && this.minB <= this.maxB;
    }

    public boolean intersects(OctagonalEnvelope other) {
        if (this.isNull() || other.isNull()) {
            return false;
        }
        if (this.minX > other.maxX) {
            return false;
        }
        if (this.maxX < other.minX) {
            return false;
        }
        if (this.minY > other.maxY) {
            return false;
        }
        if (this.maxY < other.minY) {
            return false;
        }
        if (this.minA > other.maxA) {
            return false;
        }
        if (this.maxA < other.minA) {
            return false;
        }
        if (this.minB > other.maxB) {
            return false;
        }
        return !(this.maxB < other.minB);
    }

    public boolean intersects(Coordinate p) {
        if (this.minX > p.x) {
            return false;
        }
        if (this.maxX < p.x) {
            return false;
        }
        if (this.minY > p.y) {
            return false;
        }
        if (this.maxY < p.y) {
            return false;
        }
        double A2 = OctagonalEnvelope.computeA(p.x, p.y);
        double B = OctagonalEnvelope.computeB(p.x, p.y);
        if (this.minA > A2) {
            return false;
        }
        if (this.maxA < A2) {
            return false;
        }
        if (this.minB > B) {
            return false;
        }
        return !(this.maxB < B);
    }

    public boolean contains(OctagonalEnvelope other) {
        if (this.isNull() || other.isNull()) {
            return false;
        }
        return other.minX >= this.minX && other.maxX <= this.maxX && other.minY >= this.minY && other.maxY <= this.maxY && other.minA >= this.minA && other.maxA <= this.maxA && other.minB >= this.minB && other.maxB <= this.maxB;
    }

    public Geometry toGeometry(GeometryFactory geomFactory) {
        if (this.isNull()) {
            return geomFactory.createPoint();
        }
        Coordinate px00 = new Coordinate(this.minX, this.minA - this.minX);
        Coordinate px01 = new Coordinate(this.minX, this.minX - this.minB);
        Coordinate px10 = new Coordinate(this.maxX, this.maxX - this.maxB);
        Coordinate px11 = new Coordinate(this.maxX, this.maxA - this.maxX);
        Coordinate py00 = new Coordinate(this.minA - this.minY, this.minY);
        Coordinate py01 = new Coordinate(this.minY + this.maxB, this.minY);
        Coordinate py10 = new Coordinate(this.maxY + this.minB, this.maxY);
        Coordinate py11 = new Coordinate(this.maxA - this.maxY, this.maxY);
        PrecisionModel pm = geomFactory.getPrecisionModel();
        pm.makePrecise(px00);
        pm.makePrecise(px01);
        pm.makePrecise(px10);
        pm.makePrecise(px11);
        pm.makePrecise(py00);
        pm.makePrecise(py01);
        pm.makePrecise(py10);
        pm.makePrecise(py11);
        CoordinateList coordList = new CoordinateList();
        coordList.add(px00, false);
        coordList.add(px01, false);
        coordList.add(py10, false);
        coordList.add(py11, false);
        coordList.add(px11, false);
        coordList.add(px10, false);
        coordList.add(py01, false);
        coordList.add(py00, false);
        if (coordList.size() == 1) {
            return geomFactory.createPoint(px00);
        }
        if (coordList.size() == 2) {
            Coordinate[] pts = coordList.toCoordinateArray();
            return geomFactory.createLineString(pts);
        }
        coordList.add(px00, false);
        Coordinate[] pts = coordList.toCoordinateArray();
        return geomFactory.createPolygon(geomFactory.createLinearRing(pts));
    }

    private static class BoundingOctagonComponentFilter
    implements GeometryComponentFilter {
        OctagonalEnvelope oe;

        BoundingOctagonComponentFilter(OctagonalEnvelope oe) {
            this.oe = oe;
        }

        @Override
        public void filter(Geometry geom) {
            if (geom instanceof LineString) {
                this.oe.expandToInclude(((LineString)geom).getCoordinateSequence());
            } else if (geom instanceof Point) {
                this.oe.expandToInclude(((Point)geom).getCoordinateSequence());
            }
        }
    }
}

