/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.geomgraph;

import com.hazelcast.shaded.org.locationtech.jts.geomgraph.Label;

public class Depth {
    private static final int NULL_VALUE = -1;
    private int[][] depth = new int[2][3];

    public static int depthAtLocation(int location) {
        if (location == 2) {
            return 0;
        }
        if (location == 0) {
            return 1;
        }
        return -1;
    }

    public Depth() {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.depth[i][j] = -1;
            }
        }
    }

    public int getDepth(int geomIndex, int posIndex) {
        return this.depth[geomIndex][posIndex];
    }

    public void setDepth(int geomIndex, int posIndex, int depthValue) {
        this.depth[geomIndex][posIndex] = depthValue;
    }

    public int getLocation(int geomIndex, int posIndex) {
        if (this.depth[geomIndex][posIndex] <= 0) {
            return 2;
        }
        return 0;
    }

    public void add(int geomIndex, int posIndex, int location) {
        if (location == 0) {
            int[] nArray = this.depth[geomIndex];
            int n = posIndex;
            nArray[n] = nArray[n] + 1;
        }
    }

    public boolean isNull() {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (this.depth[i][j] == -1) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isNull(int geomIndex) {
        return this.depth[geomIndex][1] == -1;
    }

    public boolean isNull(int geomIndex, int posIndex) {
        return this.depth[geomIndex][posIndex] == -1;
    }

    public void add(Label lbl) {
        for (int i = 0; i < 2; ++i) {
            for (int j = 1; j < 3; ++j) {
                int loc = lbl.getLocation(i, j);
                if (loc != 2 && loc != 0) continue;
                if (this.isNull(i, j)) {
                    this.depth[i][j] = Depth.depthAtLocation(loc);
                    continue;
                }
                int[] nArray = this.depth[i];
                int n = j;
                nArray[n] = nArray[n] + Depth.depthAtLocation(loc);
            }
        }
    }

    public int getDelta(int geomIndex) {
        return this.depth[geomIndex][2] - this.depth[geomIndex][1];
    }

    public void normalize() {
        for (int i = 0; i < 2; ++i) {
            if (this.isNull(i)) continue;
            int minDepth = this.depth[i][1];
            if (this.depth[i][2] < minDepth) {
                minDepth = this.depth[i][2];
            }
            if (minDepth < 0) {
                minDepth = 0;
            }
            for (int j = 1; j < 3; ++j) {
                int newValue = 0;
                if (this.depth[i][j] > minDepth) {
                    newValue = 1;
                }
                this.depth[i][j] = newValue;
            }
        }
    }

    public String toString() {
        return "A: " + this.depth[0][1] + "," + this.depth[0][2] + " B: " + this.depth[1][1] + "," + this.depth[1][2];
    }
}

