/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.valid;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Envelope;
import com.hazelcast.shaded.org.locationtech.jts.geom.LinearRing;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.index.SpatialIndex;
import com.hazelcast.shaded.org.locationtech.jts.index.strtree.STRtree;
import com.hazelcast.shaded.org.locationtech.jts.operation.valid.PolygonTopologyAnalyzer;
import java.util.List;

class IndexedNestedHoleTester {
    private Polygon polygon;
    private SpatialIndex index;
    private Coordinate nestedPt;

    public IndexedNestedHoleTester(Polygon poly) {
        this.polygon = poly;
        this.loadIndex();
    }

    private void loadIndex() {
        this.index = new STRtree();
        for (int i = 0; i < this.polygon.getNumInteriorRing(); ++i) {
            LinearRing hole = this.polygon.getInteriorRingN(i);
            Envelope env = hole.getEnvelopeInternal();
            this.index.insert(env, hole);
        }
    }

    public Coordinate getNestedPoint() {
        return this.nestedPt;
    }

    public boolean isNested() {
        for (int i = 0; i < this.polygon.getNumInteriorRing(); ++i) {
            LinearRing hole = this.polygon.getInteriorRingN(i);
            List results = this.index.query(hole.getEnvelopeInternal());
            for (LinearRing testHole : results) {
                if (hole == testHole || !testHole.getEnvelopeInternal().covers(hole.getEnvelopeInternal()) || !PolygonTopologyAnalyzer.isRingNested(hole, testHole)) continue;
                this.nestedPt = hole.getCoordinateN(0);
                return true;
            }
        }
        return false;
    }
}

