/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression;

import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.LazyTarget;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import java.io.IOException;

public final class ColumnExpression<T>
implements Expression<T> {
    private int index;
    private QueryDataType type;

    public ColumnExpression() {
    }

    private ColumnExpression(int index, QueryDataType type) {
        this.index = index;
        this.type = type;
    }

    public static ColumnExpression<?> create(int index, QueryDataType type) {
        if (type.getTypeFamily().equals((Object)QueryDataTypeFamily.OBJECT)) {
            return new ColumnExpression(index, type);
        }
        Class<?> canonicalClass = type.getConverter().getNormalizedValueClass();
        QueryDataType canonicalType = QueryDataTypeUtils.resolveTypeForClass(canonicalClass);
        return new ColumnExpression(index, canonicalType);
    }

    @Override
    public Object evalTop(Row row, ExpressionEvalContext context) {
        Object res = row.get(this.index, false);
        if (res instanceof LazyTarget) {
            assert (this.type.equals(QueryDataType.OBJECT));
            LazyTarget lazyTarget = (LazyTarget)res;
            res = lazyTarget.getDeserialized() != null ? lazyTarget.getDeserialized() : lazyTarget.getSerialized();
        }
        return res;
    }

    @Override
    public T eval(Row row, ExpressionEvalContext context) {
        return this.eval(row, context, false);
    }

    @Override
    public T eval(Row row, ExpressionEvalContext context, boolean useLazyDeserialization) {
        Object res = row.get(this.index, useLazyDeserialization);
        if (res instanceof LazyTarget) {
            assert (this.type.equals(QueryDataType.OBJECT));
            res = ((LazyTarget)res).deserialize((SerializationService)context.getSerializationService());
        }
        return (T)res;
    }

    @Override
    public QueryDataType getType() {
        return this.type;
    }

    public int getClassId() {
        return 32;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.index);
        out.writeObject((Object)this.type);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.index = in.readInt();
        this.type = (QueryDataType)in.readObject();
    }

    public int hashCode() {
        int result = this.index;
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnExpression that = (ColumnExpression)o;
        return this.index == that.index && this.type.equals(that.type);
    }

    public String toString() {
        return "$" + this.index;
    }

    @Override
    public boolean isCooperative() {
        return true;
    }
}

